/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.snow_real_magic;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_117;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

public class NormalizeNode
implements IDataNode,
IItemNode {
    public static final class_2960 ID = new class_2960("snowrealmagic", "item_stack");
    private final List<ITooltipNode> tooltip;
    private final float chance;

    public NormalizeNode(IServerUtils utils, float chance, int quality, List<class_117> functions, List<class_5341> conditions) {
        this.tooltip = new ArrayList<ITooltipNode>();
        this.tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.normalize", new Object[0])));
        this.tooltip.addAll(NormalizeNode.getItemTooltip(utils, chance, quality, functions, conditions));
        this.chance = chance;
    }

    public NormalizeNode(IClientUtils utils, class_9129 buf) {
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
        this.chance = 1.0f;
    }

    @Override
    public void encode(IServerUtils utils, class_9129 buf) {
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @NotNull
    private static List<ITooltipNode> getItemTooltip(IServerUtils utils, float chance, int quality, List<class_117> functions, List<class_5341> conditions) {
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, conditions, chance);
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> countMap = NormalizeNode.getCount(utils, 1, functions);
        return EntryTooltipUtils.getTooltip(utils, quality, chanceMap, countMap, functions, conditions);
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getCount(IServerUtils utils, int baseCount, List<class_117> functions) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> count = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue(baseCount)));
        for (class_117 function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    @Override
    public Either<class_1799, class_6862<? extends class_1935>> getModifiedItem() {
        return Either.left((Object)class_1799.field_8037);
    }

    @Override
    public List<class_5341> getConditions() {
        return List.of();
    }

    @Override
    public List<class_117> getFunctions() {
        return List.of();
    }

    @Override
    public RangeValue getCount() {
        return new RangeValue();
    }

    @Override
    public float getChance() {
        return this.chance;
    }
}

