/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_117;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_5341;
import net.minecraft.class_67;
import net.minecraft.class_6880;
import net.minecraft.class_83;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class EntryTooltipUtils {
    public static @Unmodifiable @NotNull List<ITooltipNode> getLootTableTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
    }

    @NotNull
    public static List<ITooltipNode> getReferenceTooltip(class_83 entry, float chance, int sumWeight) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
        tooltip.add(EntryTooltipUtils.getQualityTooltip(entry.field_994));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.field_995 / (float)sumWeight * 100.0f)));
        return tooltip;
    }

    @NotNull
    public static List<ITooltipNode> getLootPoolTooltip(RangeValue rolls, RangeValue bonusRolls) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.random", new Object[0])));
        tooltip.add(EntryTooltipUtils.getRolls(rolls, bonusRolls));
        return tooltip;
    }

    public static @Unmodifiable @NotNull List<ITooltipNode> getAlternativesTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.alternatives", new Object[0])));
    }

    @NotNull
    public static List<ITooltipNode> getDynamicTooltip(IServerUtils utils, class_67 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.dynamic", new Object[0])));
        tooltip.add(EntryTooltipUtils.getQualityTooltip(entry.field_994));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.field_995 / (float)sumWeight * 100.0f)));
        tooltip.addAll(GenericTooltipUtils.getConditionsTooltip(utils, conditions));
        tooltip.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, functions));
        return tooltip;
    }

    public static @Unmodifiable @NotNull List<ITooltipNode> getGroupTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
    }

    public static @Unmodifiable @NotNull List<ITooltipNode> getSequentialTooltip() {
        return List.of(new TooltipNode(GenericTooltipUtils.translatable("ali.enum.group_type.sequence", new Object[0])));
    }

    @NotNull
    public static List<ITooltipNode> getEmptyTooltip(IServerUtils utils, class_85 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        ArrayList<class_117> allFunctions = new ArrayList<class_117>(functions);
        ArrayList<class_5341> allConditions = new ArrayList<class_5341>(conditions);
        allFunctions.addAll(entry.field_996);
        allConditions.addAll(entry.field_988);
        float rawChance = chance * (float)entry.field_995 / (float)sumWeight;
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        tooltip.add(new TooltipNode((class_2561)class_2561.method_43471((String)"ali.enum.group_type.empty")));
        tooltip.add(EntryTooltipUtils.getQualityTooltip(entry.field_994));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(chanceMap));
        tooltip.addAll(GenericTooltipUtils.getConditionsTooltip(utils, allConditions));
        tooltip.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, allFunctions));
        return tooltip;
    }

    @NotNull
    public static List<ITooltipNode> getSingletonTooltip(IServerUtils utils, class_85 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        ArrayList<class_117> allFunctions = new ArrayList<class_117>(functions);
        ArrayList<class_5341> allConditions = new ArrayList<class_5341>(conditions);
        allFunctions.addAll(entry.field_996);
        allConditions.addAll(entry.field_988);
        float rawChance = chance * (float)entry.field_995 / (float)sumWeight;
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> countMap = TooltipUtils.getCount(utils, allFunctions);
        return EntryTooltipUtils.getTooltip(utils, entry.field_994, chanceMap, countMap, allFunctions, allConditions);
    }

    @NotNull
    public static List<ITooltipNode> getTooltip(IServerUtils utils, int quality, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> functions, List<class_5341> conditions) {
        ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
        tooltip.add(EntryTooltipUtils.getQualityTooltip(quality));
        tooltip.add(EntryTooltipUtils.getChanceTooltip(chance));
        tooltip.add(EntryTooltipUtils.getCountTooltip(count));
        tooltip.addAll(GenericTooltipUtils.getConditionsTooltip(utils, conditions));
        tooltip.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, functions));
        return tooltip;
    }

    @NotNull
    public static @Unmodifiable ITooltipNode getQualityTooltip(int quality) {
        if (quality != 0) {
            return new TooltipNode(GenericTooltipUtils.translatable("ali.description.quality", GenericTooltipUtils.value(quality)));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getChanceTooltip(Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        RangeValue defaultChance = chance.get(null).get(0);
        TooltipNode tooltip = !defaultChance.isRange() && (double)defaultChance.max() > 99.99999 ? new TooltipNode() : new TooltipNode(GenericTooltipUtils.translatable("ali.description.chance", GenericTooltipUtils.value(chance.get(null).get(0), "%")));
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceEntry : chance.entrySet()) {
            class_6880<class_1887> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.description.chance_bonus", GenericTooltipUtils.value(value, "%"), GenericTooltipUtils.value(class_2561.method_43471((String)((class_1887)enchantment.comp_349()).method_8184())), GenericTooltipUtils.value(class_2561.method_43471((String)("enchantment.level." + level))))));
            }
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getCountTooltip(Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.description.count", GenericTooltipUtils.value(count.get(null).get(0))));
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceEntry : count.entrySet()) {
            class_6880<class_1887> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.description.count_bonus", GenericTooltipUtils.value(value), GenericTooltipUtils.value(class_2561.method_43471((String)((class_1887)enchantment.comp_349()).method_8184())), GenericTooltipUtils.value(class_2561.method_43471((String)("enchantment.level." + level))))));
            }
        }
        return tooltip;
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getBaseMap(float value) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> map = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(value)));
        return map;
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getBaseMap(float min, float max) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> map = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(min, max)));
        return map;
    }

    @NotNull
    public static ITooltipNode getRolls(RangeValue rolls, RangeValue bonusRolls) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.description.rolls", GenericTooltipUtils.value(EntryTooltipUtils.getTotalRolls(rolls, bonusRolls).toIntString(), "x")));
    }

    private static RangeValue getTotalRolls(RangeValue rolls, RangeValue bonusRolls) {
        if (bonusRolls.min() > 0.0f || bonusRolls.max() > 0.0f) {
            return new RangeValue(bonusRolls).add(rolls);
        }
        return rolls;
    }
}

