/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.yanny.ali.manager.PluginManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionStatsTracker {
    private final Map<String, Long> callCounts = new HashMap<String, Long>();
    private final Logger LOGGER;

    public FunctionStatsTracker(Class<?> clazz) {
        this.LOGGER = LoggerFactory.getLogger(clazz);
    }

    public void incrementCallCount(Class<?> function) {
        if (!PluginManager.COMMON_REGISTRY.getConfiguration().logMoreStatistics) {
            return;
        }
        String functionName = function.getTypeName();
        this.callCounts.put(functionName, this.callCounts.getOrDefault(functionName, 0L) + 1L);
    }

    public void logStats() {
        if (!this.LOGGER.isInfoEnabled() || !PluginManager.COMMON_REGISTRY.getConfiguration().logMoreStatistics) {
            return;
        }
        Map top10 = this.callCounts.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(10L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        this.LOGGER.info("--- Top 10 Most Called Functions ---");
        top10.forEach((functionName, count) -> this.LOGGER.info("{}: {} calls", functionName, count));
    }

    public void clearStats() {
        this.callCounts.clear();
    }
}

