/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.mixin;

import com.yanny.ali.AliMod;
import com.yanny.ali.manager.PluginManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public class MixinMinecraftServer {
    @Inject(method={"reloadResources"}, at={@At(value="TAIL")})
    private void endResourceReload(Collection<String> collection, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((CompletableFuture)cir.getReturnValue()).handleAsync((value, throwable) -> {
            MinecraftServer server;
            if (throwable == null && (server = (MinecraftServer)this) != null) {
                PluginManager.reloadServer();
                AliMod.INFO_PROPAGATOR.server().readLootTables(server.getLootData(), server.overworld());
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    AliMod.INFO_PROPAGATOR.server().syncLootTables((Player)player);
                }
            }
            return value;
        }, (Executor)((MinecraftServer)this));
    }
}

