/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.SyncLootTableMessage;
import com.yanny.ali.network.SyncTradeMessage;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public abstract class AbstractServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<SyncLootTableMessage> lootTableMessages = new LinkedList<SyncLootTableMessage>();
    private final List<SyncTradeMessage> tradeMessages = new LinkedList<SyncTradeMessage>();

    public final void readLootTables(LootDataManager manager, ServerLevel level) {
        LOGGER.info("Started reading loot info");
        long startTime = System.currentTimeMillis();
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        AliServerRegistry serverRegistry = PluginManager.SERVER_REGISTRY;
        Map<ResourceLocation, LootTable> lootTables = AbstractServer.collectLootTables(manager);
        Map<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        HashMap<ResourceLocation, LootTable> unprocessedLootTables = new HashMap<ResourceLocation, LootTable>(lootTables);
        List<ILootModifier<?>> lootModifiers = serverRegistry.getLootModifiers();
        Map<ILootModifier.IType, List<ILootModifier>> groupedTypes = lootModifiers.stream().collect(Collectors.groupingBy(ILootModifier::getType));
        List<ILootModifier<?>> blockLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.BLOCK, Collections.emptyList());
        List<ILootModifier<?>> entityLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.ENTITY, Collections.emptyList());
        List<ILootModifier<?>> lootTableLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.LOOT_TABLE, Collections.emptyList());
        HashMap<ResourceLocation, Pair<List<Item>, List<Item>>> tradeItems = new HashMap<ResourceLocation, Pair<List<Item>, List<Item>>>();
        Pair<List<Item>, List<Item>> wanderingTraderItems = ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.WANDERING_TRADER_TRADES);
        IDataNode wanderingTraderNode = AbstractServer.processWanderingTrader(serverRegistry);
        serverRegistry.setServerLevel(level);
        lootTables.forEach(serverRegistry::addLootTable);
        Map<ResourceLocation, List<Item>> lootTableItems = lootTables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, AbstractServer::getItems));
        this.lootTableMessages.clear();
        this.tradeMessages.clear();
        lootNodes.putAll(AbstractServer.processBlocks(serverRegistry, config, unprocessedLootTables, blockLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processEntities(serverRegistry, config, level, unprocessedLootTables, entityLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processLootTables(serverRegistry, config, unprocessedLootTables, lootTableLootModifiers, lootTableItems));
        Map<ResourceLocation, List<ItemStack>> lootTableItemStacks = lootNodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AbstractServer.collectItems((IDataNode)e.getValue())));
        lootNodes = AbstractServer.removeEmptyLootTable(lootNodes, lootTableItemStacks);
        HashMap<ResourceLocation, IDataNode> tradeNodes = new HashMap<ResourceLocation, IDataNode>(AbstractServer.processTrades(serverRegistry, config, tradeItems));
        this.sendLootData(lootTableItemStacks, lootNodes);
        this.sendTradeData(tradeNodes, tradeItems, wanderingTraderNode, wanderingTraderItems);
        serverRegistry.clearLootTables();
        serverRegistry.printRuntimeInfo();
        LOGGER.info("Processing {} loot tables and {} trades took {}ms", new Object[]{lootNodes.size(), tradeNodes.size() + 1, System.currentTimeMillis() - startTime});
    }

    public final void syncLootTables(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LOGGER.info("Started syncing loot info to {}", (Object)player.getScoreboardName());
            this.sendClearMessage(serverPlayer, new ClearMessage(this.lootTableMessages.size() + this.tradeMessages.size()));
            for (SyncLootTableMessage syncLootTableMessage : this.lootTableMessages) {
                try {
                    this.sendSyncLootTableMessage(serverPlayer, syncLootTableMessage);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to send message for loot table {} with error: {}", (Object)syncLootTableMessage.location, (Object)e.getMessage());
                }
            }
            for (SyncTradeMessage syncTradeMessage : this.tradeMessages) {
                try {
                    this.sendSyncTradeMessage(serverPlayer, syncTradeMessage);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to send message for trade {} with error: {}", (Object)syncTradeMessage.location, (Object)e.getMessage());
                }
            }
            this.sendDoneMessage(serverPlayer, new DoneMessage());
            LOGGER.info("Finished syncing loot info to {}", (Object)player.getScoreboardName());
        }
    }

    protected abstract void sendClearMessage(ServerPlayer var1, ClearMessage var2);

    protected abstract void sendSyncLootTableMessage(ServerPlayer var1, SyncLootTableMessage var2);

    protected abstract void sendSyncTradeMessage(ServerPlayer var1, SyncTradeMessage var2);

    protected abstract void sendDoneMessage(ServerPlayer var1, DoneMessage var2);

    @NotNull
    private static List<Item> getItems(Map.Entry<ResourceLocation, LootTable> lootTableMap) {
        return ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, lootTableMap.getValue());
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> removeEmptyLootTable(Map<ResourceLocation, IDataNode> lootNodes, Map<ResourceLocation, List<ItemStack>> items) {
        HashMap<ResourceLocation, IDataNode> result = new HashMap<ResourceLocation, IDataNode>();
        int emptyLootTables = 0;
        for (Map.Entry<ResourceLocation, IDataNode> entry : lootNodes.entrySet()) {
            if (!items.getOrDefault(entry.getKey(), Collections.emptyList()).isEmpty()) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            ++emptyLootTables;
        }
        LOGGER.info("Skipped {} empty or hidden loot tables", (Object)emptyLootTables);
        return result;
    }

    @NotNull
    private static Map<ResourceLocation, LootTable> collectLootTables(LootDataManager manager) {
        HashMap<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
        manager.getKeys(LootDataType.TABLE).forEach(location -> lootTables.put((ResourceLocation)location, manager.getLootTable(location)));
        return lootTables;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processBlocks(AliServerRegistry serverRegistry, AliConfig config, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> blockLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (Block block : BuiltInRegistries.BLOCK) {
            ResourceLocation location = block.getLootTable();
            if (location == null) continue;
            LootTable lootTable = lootTables.remove(location);
            if (config.blockCategories.stream().filter(f -> f.validate(block)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) {
                List items = lootTableItems.getOrDefault(location, Collections.emptyList());
                List<ILootModifier<?>> lootModifiers = Stream.concat(blockLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, block, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                try {
                    if (lootTable != null) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                        continue;
                    }
                    if (!lootModifiers.isEmpty()) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers));
                        continue;
                    }
                    LOGGER.debug("Missing block loot table for {}", (Object)block);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to parse block loot table {} with error {}", (Object)location, (Object)e.getMessage());
                }
                continue;
            }
            lootTables.remove(location);
        }
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processEntities(AliServerRegistry serverRegistry, AliConfig config, ServerLevel level, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> entityLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType)))) {
                lootTables.remove(entityType.getDefaultLootTable());
                continue;
            }
            List<Entity> entityList = serverRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : entityList) {
                Mob mob;
                ResourceLocation location;
                if (!(entity instanceof Mob) || (location = (mob = (Mob)entity).getLootTable()) == null) continue;
                LootTable lootTable = lootTables.remove(location);
                if (!config.entityCategories.stream().filter(f -> f.validate(entityType)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) continue;
                List items = lootTableItems.getOrDefault(location, Collections.emptyList());
                List<ILootModifier<?>> lootModifiers = Stream.concat(entityLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, entity, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                try {
                    if (lootTable != null) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                        continue;
                    }
                    if (!lootModifiers.isEmpty()) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers));
                        continue;
                    }
                    LOGGER.debug("Missing entity loot table for {}", (Object)entity);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to parse entity loot table {} with error {}", (Object)location, (Object)e.getMessage());
                }
            }
        }
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processLootTables(AliServerRegistry serverRegistry, AliConfig config, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (Map.Entry<ResourceLocation, LootTable> entry : lootTables.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (!config.gameplayCategories.stream().filter(f -> f.validate(location)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) continue;
            LootTable lootTable = entry.getValue();
            List<Item> items = lootTableItems.get(location);
            List<ILootModifier<?>> lootModifiers = lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items)).toList();
            try {
                lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.warn("Failed to parse loot table {} with error {}", (Object)location, (Object)e.getMessage());
            }
        }
        lootTables.clear();
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processTrades(AliServerRegistry serverRegistry, AliConfig config, Map<ResourceLocation, Pair<List<Item>, List<Item>>> tradeItems) {
        HashMap<ResourceLocation, IDataNode> nodes = new HashMap<ResourceLocation, IDataNode>();
        for (Map.Entry entry : BuiltInRegistries.VILLAGER_PROFESSION.entrySet()) {
            ResourceLocation location = ((ResourceKey)entry.getKey()).location();
            if (!config.tradeCategories.stream().filter(f -> f.validate(location)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) continue;
            Int2ObjectMap itemListingMap = (Int2ObjectMap)VillagerTrades.TRADES.get(entry.getValue());
            if (itemListingMap != null && itemListingMap.int2ObjectEntrySet().stream().anyMatch(e -> ((VillagerTrades.ItemListing[])e.getValue()).length > 0)) {
                try {
                    nodes.put(location, serverRegistry.parseTrade((Int2ObjectMap<VillagerTrades.ItemListing[]>)itemListingMap));
                    tradeItems.put(location, ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<VillagerTrades.ItemListing[]>)itemListingMap));
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                    LOGGER.warn("Failed to parse trade for villager {} with error {}", (Object)((VillagerProfession)entry.getValue()).name(), (Object)e2.getMessage());
                }
                continue;
            }
            LOGGER.warn("No trades defined for {}", (Object)location);
        }
        return nodes;
    }

    @NotNull
    private static IDataNode processWanderingTrader(AliServerRegistry serverRegistry) {
        try {
            return serverRegistry.parseTrade((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.WANDERING_TRADER_TRADES);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Failed to parse wandering trader with error {}", (Object)e.getMessage());
            return new MissingNode();
        }
    }

    private static <T> boolean predicateModifier(ILootModifier<?> modifier, T value, List<Item> items) {
        return modifier.predicate(value) && AbstractServer.predicateItem(modifier, items);
    }

    private static boolean predicateItem(ILootModifier<?> modifier, List<Item> items) {
        if (!items.isEmpty()) {
            return items.stream().anyMatch(i -> modifier.getOperations().stream().anyMatch(o -> o.predicate().test(i.getDefaultInstance())));
        }
        return true;
    }

    @NotNull
    private static List<ItemStack> collectItems(IDataNode node) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            for (IDataNode n : listNode.nodes()) {
                itemStacks.addAll(AbstractServer.collectItems(n));
            }
        } else if (node instanceof IItemNode) {
            IItemNode itemNode = (IItemNode)((Object)node);
            itemStacks.addAll((Collection)itemNode.getModifiedItem().map(List::of, AbstractServer::toItemStacks));
        }
        return itemStacks;
    }

    private void sendLootData(Map<ResourceLocation, List<ItemStack>> lootTableItemStacks, Map<ResourceLocation, IDataNode> lootNodes) {
        lootNodes.forEach((location, lootNode) -> this.lootTableMessages.add(new SyncLootTableMessage((ResourceLocation)location, lootTableItemStacks.getOrDefault(location, Collections.emptyList()), (IDataNode)lootNode)));
    }

    private void sendTradeData(Map<ResourceLocation, IDataNode> trades, Map<ResourceLocation, Pair<List<Item>, List<Item>>> items, IDataNode wanderingTraderNode, Pair<List<Item>, List<Item>> wanderingTraderItems) {
        trades.forEach((location, node) -> this.tradeMessages.add(new SyncTradeMessage((ResourceLocation)location, (IDataNode)node, (Pair<List<Item>, List<Item>>)((Pair)items.get(location)))));
        this.tradeMessages.add(new SyncTradeMessage(wanderingTraderNode, wanderingTraderItems));
    }

    private static <T extends ItemLike> List<ItemStack> toItemStacks(TagKey<T> tag) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(tag.registry().location());
        if (registry != null) {
            return registry.getTag(tag).map(holders -> holders.stream().map(Holder::value).map(i -> i.asItem().getDefaultInstance()).toList()).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }
}

