/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SyncLootTableMessage
implements CustomPacketPayload {
    public static final ResourceLocation ID = Utils.modLoc("loot_table_sync");
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ResourceLocation location;
    public final List<ItemStack> items;
    public final IDataNode node;

    public SyncLootTableMessage(ResourceLocation location, List<ItemStack> items, IDataNode node) {
        this.location = location;
        this.items = items;
        this.node = node;
    }

    public SyncLootTableMessage(FriendlyByteBuf buf) {
        Object dataNode;
        this.location = buf.readResourceLocation();
        this.items = buf.readList(FriendlyByteBuf::readItem);
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            dataNode = utils.getDataNodeFactory(LootTableNode.ID).create(utils, buf);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to decode node for loot table {} with error: {}", (Object)this.location, (Object)e.getMessage());
            dataNode = new MissingNode();
        }
        this.node = dataNode;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.location);
        buf.writeCollection(this.items, FriendlyByteBuf::writeItem);
        AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
        try {
            this.node.encode(utils, buf);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to encode node with error: {}", (Object)e.getMessage());
            new MissingNode().encode(utils, buf);
        }
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }
}

