/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericTooltipUtils {
    @NotNull
    public static ITooltipNode getMissingFunction(IServerUtils utils, LootItemFunction function) {
        return RegistriesTooltipUtils.getFunctionTypeTooltip(utils, function.getType()).build("ali.util.advanced_loot_info.missing");
    }

    @NotNull
    public static ITooltipNode getMissingCondition(IServerUtils utils, LootItemCondition condition) {
        return RegistriesTooltipUtils.getConditionTypeTooltip(utils, condition.getType()).build("ali.util.advanced_loot_info.missing");
    }

    @NotNull
    public static ITooltipNode getConditionListTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemCondition condition : conditions) {
            array.add(utils.getConditionTooltip(utils, condition));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.conditions")).add(GenericTooltipUtils.getConditionListTooltip(utils, conditions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getSubConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getFunctionListTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemFunction function : functions) {
            array.add(utils.getFunctionTooltip(utils, function));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getFunctionsTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        if (!functions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.functions")).add(GenericTooltipUtils.getFunctionListTooltip(utils, functions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        String name = propertyMatcher.name();
        StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.valueMatcher();
        if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
            StatePropertiesPredicate.ExactMatcher matcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
            return ValueTooltipNode.keyValue(name, matcher.value()).build("ali.property.value.null");
        }
        valueMatcher = propertyMatcher.valueMatcher();
        if (valueMatcher instanceof StatePropertiesPredicate.RangedMatcher) {
            StatePropertiesPredicate.RangedMatcher matcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
            Optional min = matcher.minValue();
            Optional max = matcher.maxValue();
            if (min.isPresent()) {
                if (max.isPresent()) {
                    return ValueTooltipNode.value(name, min.get(), max.get()).build("ali.property.value.ranged_property_both");
                }
                return ValueTooltipNode.value(name, min.get()).build("ali.property.value.ranged_property_gte");
            }
            if (max.isPresent()) {
                return ValueTooltipNode.value(name, max.get()).build("ali.property.value.ranged_property_lte");
            }
            return ValueTooltipNode.value(name).build("ali.property.value.ranged_property_any");
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getStatMatcherTooltip(IServerUtils utils, PlayerPredicate.StatMatcher<?> stat) {
        ITooltipNode tooltip;
        String key = ValueTooltipNode.translate(((TranslatableContents)stat.type().getDisplayName().getContents()).getKey());
        Holder value = stat.value();
        Object object = value.value();
        if (object instanceof Item) {
            Item item = (Item)object;
            tooltip = utils.getValueTooltip(utils, item).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.item");
        } else {
            object = value.value();
            if (object instanceof Block) {
                Block block = (Block)object;
                tooltip = utils.getValueTooltip(utils, block).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.block");
            } else {
                object = value.value();
                if (object instanceof EntityType) {
                    EntityType entityType = (EntityType)object;
                    tooltip = utils.getValueTooltip(utils, entityType).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.entity_type");
                } else {
                    object = value.value();
                    if (object instanceof ResourceLocation) {
                        ResourceLocation resourceLocation = (ResourceLocation)object;
                        tooltip = utils.getValueTooltip(utils, resourceLocation).add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(GenericTooltipUtils.getTranslationKey(resourceLocation)), GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.id");
                    } else {
                        tooltip = EmptyTooltipNode.EMPTY;
                    }
                }
            }
        }
        return tooltip;
    }

    @NotNull
    public static <T> IKeyTooltipNode getCollectionTooltip(IServerUtils utils, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, String value, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build(value));
        }
        return tooltip;
    }

    @NotNull
    public static <K, V> IKeyTooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<ResourceLocation, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, IntRange> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.limit")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue().amplifier()).build("ali.property.value.amplifier")).add(utils.getValueTooltip(utils, entry.getValue().duration()).build("ali.property.value.duration")).add(utils.getValueTooltip(utils, entry.getValue().ambient()).build("ali.property.value.is_ambient")).add(utils.getValueTooltip(utils, entry.getValue().visible()).build("ali.property.value.is_visible")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<Holder<Enchantment>, NumberProvider> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.levels")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, entry.getKey());
        IKeyTooltipNode value = utils.getValueTooltip(utils, entry.getValue());
        if (value instanceof ValueTooltipNode.Builder) {
            tooltip.add(value.build("ali.property.value.done"));
        } else {
            tooltip.add(value.build("ali.property.branch.criterions"));
        }
        return tooltip.build("ali.property.value.null");
    }

    @NotNull
    public static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.min();
        Optional max = doubles.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    public static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.min();
        Optional max = ints.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static String getTranslationKey(ResourceLocation location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

