/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiWidgetWrapper;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.client.EntryTooltipUtils;
import com.yanny.ali.plugin.client.TooltipUtils;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import com.yanny.ali.registries.LootCategory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReiBaseCategory<T extends ReiBaseDisplay, U>
implements DisplayCategory<T> {
    private final LootCategory<U> lootCategory;

    public ReiBaseCategory(LootCategory<U> lootCategory) {
        this.lootCategory = lootCategory;
    }

    public abstract List<Widget> setupDisplay(T var1, Rectangle var2);

    public int getDisplayWidth(T display) {
        return 170;
    }

    public int getDisplayHeight() {
        return 144;
    }

    public LootCategory<U> getLootCategory() {
        return this.lootCategory;
    }

    protected List<Widget> getBaseWidget(T display, Rectangle bounds, int x, int y) {
        LinkedList<Widget> slotWidgets = new LinkedList<Widget>();
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        ReiWidgetWrapper widget = new ReiWidgetWrapper(new LootTableWidget(this.getUtils(slotWidgets, bounds), ((ReiBaseDisplay)((Object)display)).getLootEntry(), x + 4, y + 4), bounds);
        widgets.add(Widgets.createTooltip(widget::getTooltip));
        widgets.add((Widget)widget);
        widgets.addAll(slotWidgets);
        return widgets;
    }

    @NotNull
    private IWidgetUtils getUtils(final List<Widget> widgets, final Rectangle bounds) {
        return new ClientUtils(){

            @Override
            public Rect addSlotWidget(Item item, LootPoolEntryContainer entry, int x, int y, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> allFunctions, List<LootItemCondition> allConditions) {
                ItemStack itemStack = TooltipUtils.getItemStack(this, entry, item);
                EntryStack stack = EntryStacks.of((ItemStack)itemStack);
                stack.tooltip(EntryTooltipUtils.getTooltip(this, entry, chance, count, allFunctions, allConditions));
                widgets.add(Widgets.createSlot((Point)new Point(x + bounds.getX() + 1, y + bounds.getY() + 1)).entry(stack).markOutput());
                widgets.add(Widgets.wrapRenderer((Rectangle)new Rectangle(x + bounds.getX(), y + bounds.getY(), 18, 18), (Renderer)new SlotCountRenderer(count.get(null).get(0))));
                return new Rect(x, y, 18, 18);
            }

            @Override
            public Rect addSlotWidget(TagKey<Item> item, LootPoolEntryContainer entry, int x, int y, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> allFunctions, List<LootItemCondition> allConditions) {
                EntryIngredient ingredient = EntryIngredients.ofItemTag(item);
                ingredient.map(stack -> stack.tooltip(EntryTooltipUtils.getTooltip(this, entry, chance, count, allFunctions, allConditions)));
                widgets.add(Widgets.createSlot((Point)new Point(x + bounds.getX() + 1, y + bounds.getY() + 1)).entries((Collection)ingredient).markOutput());
                widgets.add(Widgets.wrapRenderer((Rectangle)new Rectangle(x + bounds.getX(), y + bounds.getY(), 18, 18), (Renderer)new SlotCountRenderer(count.get(null).get(0))));
                return new Rect(x, y, 18, 18);
            }
        };
    }

    private static class SlotCountRenderer
    implements Renderer {
        @Nullable
        private Component count;
        private boolean isRange = false;

        public SlotCountRenderer(RangeValue count) {
            if (count.isRange() || count.min() > 1.0f) {
                this.count = Component.m_237113_((String)count.toIntString());
                this.isRange = count.isRange();
            }
        }

        public void render(GuiGraphics guiGraphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (this.count != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                PoseStack stack = guiGraphics.m_280168_();
                stack.m_85836_();
                stack.m_252880_((float)bounds.getX(), (float)bounds.getY(), 0.0f);
                if (this.isRange) {
                    stack.m_252880_(17.0f, 13.0f, 200.0f);
                    stack.m_85836_();
                    stack.m_85841_(0.5f, 0.5f, 0.5f);
                    guiGraphics.m_280614_(font, this.count, -font.m_92852_((FormattedText)this.count), 0, 0xFFFFFF, false);
                    stack.m_85849_();
                } else {
                    stack.m_252880_(18.0f, 10.0f, 200.0f);
                    guiGraphics.m_280614_(font, this.count, -font.m_92852_((FormattedText)this.count), 0, 0xFFFFFF, true);
                }
                stack.m_85849_();
            }
        }
    }
}

