/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.InfoSyncLootTableMessage;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.slf4j.Logger;

public abstract class AbstractServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<InfoSyncLootTableMessage> messages = new LinkedList<InfoSyncLootTableMessage>();

    public final void readLootTables(LootDataManager manager, ServerLevel level) {
        this.messages.clear();
        PluginManager.SERVER_REGISTRY.setServerLevel(level);
        manager.m_278706_(LootDataType.f_278413_).forEach(table -> PluginManager.SERVER_REGISTRY.addLootTable((ResourceLocation)table, manager.m_278676_(table)));
        manager.m_278706_(LootDataType.f_278413_).forEach(location -> {
            LootTable table = manager.m_278676_(location);
            if (table != LootTable.f_79105_) {
                List<Item> items = ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, table);
                if (!items.isEmpty()) {
                    this.messages.add(new InfoSyncLootTableMessage((ResourceLocation)location, table, items));
                } else {
                    LOGGER.info("LootTable {} has no items", location);
                }
            } else {
                LOGGER.warn("Ignoring {} LootTable, because it's empty or null", location);
            }
        });
        LOGGER.info("Prepared {} loot tables", (Object)this.messages.size());
    }

    public final void syncLootTables(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendClearMessage(serverPlayer, new ClearMessage());
            for (InfoSyncLootTableMessage message : this.messages) {
                this.sendSyncMessage(serverPlayer, message);
            }
        }
    }

    protected abstract void sendClearMessage(ServerPlayer var1, ClearMessage var2);

    protected abstract void sendSyncMessage(ServerPlayer var1, InfoSyncLootTableMessage var2);
}

