/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.Client;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.network.InfoSyncLootTableMessage;
import com.yanny.ali.network.Server;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    private static int messageId = 0;

    public static DistHolder<AbstractClient, AbstractServer> registerLootInfoPropagator(SimpleChannel channel) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return NetworkUtils.registerClientLootInfoPropagator(channel);
        }
        return NetworkUtils.registerServerLootInfoPropagator(channel);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerClientLootInfoPropagator(SimpleChannel channel) {
        Client client = new Client();
        Server server = new Server(channel);
        channel.messageBuilder(InfoSyncLootTableMessage.class, NetworkUtils.getMessageId()).encoder(InfoSyncLootTableMessage::encode).decoder(InfoSyncLootTableMessage::new).consumerNetworkThread(client::onLootInfo).add();
        channel.messageBuilder(ClearMessage.class, NetworkUtils.getMessageId()).encoder(ClearMessage::encode).decoder(ClearMessage::new).consumerNetworkThread(client::onClear).add();
        return new DistHolder<AbstractClient, AbstractServer>(client, server);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerServerLootInfoPropagator(SimpleChannel channel) {
        Server server = new Server(channel);
        channel.messageBuilder(InfoSyncLootTableMessage.class, NetworkUtils.getMessageId()).encoder(InfoSyncLootTableMessage::encode).decoder(InfoSyncLootTableMessage::new).add();
        channel.messageBuilder(ClearMessage.class, NetworkUtils.getMessageId()).encoder(ClearMessage::encode).decoder(ClearMessage::new).add();
        return new DistHolder<Object, Server>(null, server);
    }

    private static int getMessageId() {
        return ++messageId;
    }
}

