/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GenericTooltipUtils {
    private static final ChatFormatting TEXT_STYLE = ChatFormatting.GOLD;
    private static final ChatFormatting PARAM_STYLE = ChatFormatting.AQUA;

    @NotNull
    public static List<Component> getConditionsTooltip(IClientUtils utils, int pad, List<LootItemCondition> conditions) {
        return conditions.stream().map(condition -> utils.getConditionTooltip(utils, pad, condition)).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<Component> getFunctionsTooltip(IClientUtils utils, int pad, List<LootItemFunction> functions) {
        return functions.stream().map(function -> {
            LinkedList<Component> components = new LinkedList<Component>(utils.getFunctionTooltip(utils, pad, function));
            if (function instanceof LootItemConditionalFunction) {
                LootItemConditionalFunction conditionalFunction = (LootItemConditionalFunction)function;
                if (!conditionalFunction.f_80676_.isEmpty()) {
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.conditions", new Object[0])));
                    components.addAll(GenericTooltipUtils.getConditionsTooltip(utils, pad + 2, conditionalFunction.f_80676_));
                }
            }
            return components;
        }).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<Component> getFormulaTooltip(IClientUtils utils, int pad, ApplyBonusCount.Formula formula) {
        LinkedList<Component> components = new LinkedList<Component>(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.formula", formula.m_5713_().f_291058_()));
        if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
            ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
            components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.extra_rounds", binomialWithBonusCount.f_79948_()));
            components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 1, "ali.property.value.probability", Float.valueOf(binomialWithBonusCount.f_79949_())));
        } else if (formula instanceof ApplyBonusCount.UniformBonusCount) {
            ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
            components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.bonus_multiplier", uniformBonusCount.f_80013_()));
        }
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getBlockTooltip(IClientUtils ignoredUtils, int pad, Block block) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.block", GenericTooltipUtils.value(GenericTooltipUtils.translatable(block.m_7705_(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getPropertyTooltip(IClientUtils ignoredUtils, int pad, Property<?> property) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.pair(property.m_61708_(), property.m_6908_().toString()))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnchantmentTooltip(IClientUtils utils, int pad, Enchantment enchantment) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.enchantment", GenericTooltipUtils.value(GenericTooltipUtils.translatable(enchantment.m_44704_(), new Object[0])))));
    }

    @NotNull
    public static List<Component> getModifierTooltip(IClientUtils utils, int pad, SetAttributesFunction.Modifier modifier) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.modifier", new Object[0])));
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad + 1, "ali.property.value.name", modifier.f_80847_()));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, modifier.f_80848_(), GenericTooltipUtils::getAttributeTooltip));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.operation", modifier.f_80849_()));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.amount", modifier.f_80850_()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, modifier.f_80851_(), GenericTooltipUtils::getUUIDTooltip));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.equipment_slots", modifier.f_80852_(), GenericTooltipUtils::getEnumTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getAttributeTooltip(IClientUtils ignoredUtils, int pad, Attribute attribute) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.attribute", GenericTooltipUtils.value(GenericTooltipUtils.translatable(attribute.m_22087_(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getUUIDTooltip(IClientUtils utils, int pad, UUID uuid) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.uuid", GenericTooltipUtils.value(uuid))));
    }

    @NotNull
    public static List<Component> getBannerPatternTooltip(IClientUtils utils, int pad, Pair<Holder<BannerPattern>, DyeColor> pair) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad, (Holder)pair.getFirst(), GenericTooltipUtils::getBannerPatternTooltip));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.color", (Enum)pair.getSecond()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getBannerPatternTooltip(IClientUtils utils, int pad, BannerPattern bannerPattern) {
        return GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad, "ali.property.value.banner_pattern", BuiltInRegistries.f_256878_, bannerPattern);
    }

    public static @Unmodifiable @NotNull List<Component> getBlockEntityTypeTooltip(IClientUtils utils, int pad, BlockEntityType<?> blockEntityType) {
        return GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad, "ali.property.value.block_entity_type", BuiltInRegistries.f_257049_, blockEntityType);
    }

    public static @Unmodifiable @NotNull List<Component> getPotionTooltip(IClientUtils utils, int pad, Potion potion) {
        return GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad, "ali.property.value.potion", BuiltInRegistries.f_256980_, potion);
    }

    public static @Unmodifiable @NotNull List<Component> getMobEffectTooltip(IClientUtils utils, int pad, MobEffect mobEffect) {
        return GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad, "ali.property.value.mob_effect", BuiltInRegistries.f_256974_, mobEffect);
    }

    @NotNull
    public static List<Component> getStatePropertiesPredicateTooltip(IClientUtils utils, int pad, StatePropertiesPredicate propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.state_properties_predicate", propertiesPredicate.f_67659_(), GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    @NotNull
    public static List<Component> getPropertyMatcherTooltip(IClientUtils ignoredUtils, int pad, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        StatePropertiesPredicate.ExactMatcher matcher;
        LinkedList<Component> components = new LinkedList<Component>();
        String name = propertyMatcher.f_67715_();
        StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.f_291902_();
        if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
            matcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.keyValue(name, matcher.f_290506_())));
        }
        if ((valueMatcher = propertyMatcher.f_291902_()) instanceof StatePropertiesPredicate.RangedMatcher) {
            matcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
            Optional min = matcher.f_291542_();
            Optional max = matcher.f_291806_();
            if (min.isPresent()) {
                if (max.isPresent()) {
                    components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_both", name, min.get(), max.get()))));
                } else {
                    components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_gte", name, min.get()))));
                }
            } else if (max.isPresent()) {
                components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_lte", name, max.get()))));
            } else {
                components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_any", name))));
            }
        }
        return components;
    }

    @NotNull
    public static List<Component> getDamageSourcePredicateTooltip(IClientUtils utils, int pad, DamageSourcePredicate damagePredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.damage_source_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.tag_predicates", damagePredicate.f_268608_(), GenericTooltipUtils::getTagPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.direct_entity", damagePredicate.f_25429_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.source_entity", damagePredicate.f_25430_(), GenericTooltipUtils::getEntityPredicateTooltip));
        return components;
    }

    public static <T> @Unmodifiable @NotNull List<Component> getTagPredicateTooltip(IClientUtils utils, int pad, TagPredicate<T> tagPredicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.keyValue(tagPredicate.f_268479_().f_203868_(), tagPredicate.f_268414_())));
    }

    @NotNull
    public static List<Component> getEntityPredicateTooltip(IClientUtils utils, int pad, EntityPredicate entityPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36551_(), GenericTooltipUtils::getEntityTypePredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.distance_to_player", entityPredicate.f_36552_(), GenericTooltipUtils::getDistancePredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.location", entityPredicate.f_36553_(), GenericTooltipUtils::getLocationPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.stepping_on_location", entityPredicate.f_150285_(), GenericTooltipUtils::getLocationPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36554_(), GenericTooltipUtils::getMobEffectPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36555_(), GenericTooltipUtils::getNbtPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36556_(), GenericTooltipUtils::getEntityFlagsPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36557_(), GenericTooltipUtils::getEntityEquipmentPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_218773_(), GenericTooltipUtils::getEntitySubPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.vehicle", entityPredicate.f_36560_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.passenger", entityPredicate.f_150287_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.targeted_entity", entityPredicate.f_36561_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.team", entityPredicate.f_36562_(), GenericTooltipUtils::getStringTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityTypePredicateTooltip(IClientUtils utils, int pad, EntityTypePredicate entityTypePredicate) {
        return GenericTooltipUtils.getHolderSetTooltip(utils, pad, "ali.property.branch.entity_types", entityTypePredicate.f_290696_(), GenericTooltipUtils::getEntityTypeTooltip);
    }

    public static @Unmodifiable @NotNull List<Component> getEntityTypeTooltip(IClientUtils utils, int pad, EntityType<?> entityType) {
        return GenericTooltipUtils.getComponentTooltip(utils, pad, "ali.property.value.entity_type", GenericTooltipUtils.value(GenericTooltipUtils.translatable(entityType.m_20675_(), new Object[0])));
    }

    @NotNull
    public static List<Component> getDistancePredicateTooltip(IClientUtils utils, int pad, DistancePredicate distancePredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.x", distancePredicate.f_26242_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.y", distancePredicate.f_26243_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.z", distancePredicate.f_26244_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.horizontal", distancePredicate.f_26245_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.absolute", distancePredicate.f_26246_()));
        return components;
    }

    @NotNull
    public static List<Component> getLocationPredicateTooltip(IClientUtils utils, int pad, LocationPredicate locationPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.f_290578_(), GenericTooltipUtils::getPositionPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.biome", locationPredicate.f_52597_(), GenericTooltipUtils::getResourceKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.structure", locationPredicate.f_220588_(), GenericTooltipUtils::getResourceKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.dimension", locationPredicate.f_52599_(), GenericTooltipUtils::getResourceKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.smokey", locationPredicate.f_52600_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.f_52601_(), GenericTooltipUtils::getLightPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.f_52602_(), GenericTooltipUtils::getBlockPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, locationPredicate.f_52603_(), GenericTooltipUtils::getFluidPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getPositionPredicateTooltip(IClientUtils utils, int pad, LocationPredicate.PositionPredicate positionPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.position", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.x", positionPredicate.f_291501_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.y", positionPredicate.f_291292_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.z", positionPredicate.f_290699_()));
        return components;
    }

    @NotNull
    public static List<Component> getLightPredicateTooltip(IClientUtils utils, int pad, LightPredicate lightPredicate) {
        return GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.light", lightPredicate.f_51336_());
    }

    @NotNull
    public static List<Component> getBlockPredicateTooltip(IClientUtils utils, int pad, BlockPredicate blockPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.block_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.tag", blockPredicate.f_17903_(), GenericTooltipUtils::getTagKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad + 1, "ali.property.branch.blocks", blockPredicate.f_146710_(), GenericTooltipUtils::getBlockTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, blockPredicate.f_17905_(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, blockPredicate.f_17906_(), GenericTooltipUtils::getNbtPredicateTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getNbtPredicateTooltip(IClientUtils utils, int pad, NbtPredicate nbtPredicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.nbt", GenericTooltipUtils.value(nbtPredicate.f_57472_()))));
    }

    @NotNull
    public static List<Component> getFluidPredicateTooltip(IClientUtils utils, int pad, FluidPredicate fluidPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.fluid_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.tag", fluidPredicate.f_41095_(), GenericTooltipUtils::getTagKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalHolderTooltip(utils, pad + 1, fluidPredicate.f_41096_(), GenericTooltipUtils::getFluidTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, fluidPredicate.f_41097_(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getFluidTooltip(IClientUtils utils, int pad, Fluid fluid) {
        return GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad, "ali.property.value.fluid", BuiltInRegistries.f_257020_, fluid);
    }

    @NotNull
    public static List<Component> getMobEffectPredicateTooltip(IClientUtils utils, int pad, MobEffectsPredicate mobEffectsPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.mob_effects", new Object[0])));
        mobEffectsPredicate.f_290320_().forEach((effect, instancePredicate) -> {
            components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, effect, GenericTooltipUtils::getMobEffectTooltip));
            components.addAll(GenericTooltipUtils.getMobEffectInstancePredicateTooltip(utils, pad + 2, instancePredicate));
        });
        return components;
    }

    @NotNull
    public static List<Component> getMobEffectInstancePredicateTooltip(IClientUtils utils, int pad, MobEffectsPredicate.MobEffectInstancePredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.amplifier", predicate.f_56566_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.duration", predicate.f_56567_()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.is_ambient", predicate.f_56568_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.is_visible", predicate.f_56569_(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityFlagsPredicateTooltip(IClientUtils utils, int pad, EntityFlagsPredicate entityFlagsPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.entity_flags", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_on_fire", entityFlagsPredicate.f_33683_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_baby", entityFlagsPredicate.f_33687_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_crouching", entityFlagsPredicate.f_33684_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_sprinting", entityFlagsPredicate.f_33685_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_swimming", entityFlagsPredicate.f_33686_(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityEquipmentPredicateTooltip(IClientUtils utils, int pad, EntityEquipmentPredicate entityEquipmentPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.entity_equipment", new Object[0])));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.head", entityEquipmentPredicate.f_32178_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.chest", entityEquipmentPredicate.f_32179_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.legs", entityEquipmentPredicate.f_32180_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.feet", entityEquipmentPredicate.f_32181_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.mainhand", entityEquipmentPredicate.f_32182_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.offhand", entityEquipmentPredicate.f_32183_(), GenericTooltipUtils::getItemPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getItemPredicateTooltip(IClientUtils utils, int pad, ItemPredicate itemPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.tag", itemPredicate.f_45029_(), GenericTooltipUtils::getTagKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad, "ali.property.branch.items", itemPredicate.f_151427_(), GenericTooltipUtils::getItemTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.count", itemPredicate.f_45031_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.durability", itemPredicate.f_45032_()));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.enchantments", itemPredicate.f_45033_(), GenericTooltipUtils::getEnchantmentPredicateTooltip));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.stored_enchantments", itemPredicate.f_45034_(), GenericTooltipUtils::getEnchantmentPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalHolderTooltip(utils, pad, itemPredicate.f_45035_(), GenericTooltipUtils::getPotionTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, itemPredicate.f_45036_(), GenericTooltipUtils::getNbtPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEnchantmentPredicateTooltip(IClientUtils utils, int pad, EnchantmentPredicate enchantmentPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalHolderTooltip(utils, pad, enchantmentPredicate.f_30466_(), GenericTooltipUtils::getEnchantmentTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.level", enchantmentPredicate.f_30467_()));
        return components;
    }

    @NotNull
    public static List<Component> getEntitySubPredicateTooltip(IClientUtils utils, int pad, EntitySubPredicate entitySubPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        Optional<Map.Entry> optional = EntitySubPredicate.Types.f_218854_.entrySet().stream().filter(p -> p.getValue() == entitySubPredicate.m_213836_()).findFirst();
        optional.ifPresent(entry -> {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.entity_sub_predicate", entry.getKey())));
            if (entitySubPredicate instanceof LightningBoltPredicate) {
                LightningBoltPredicate predicate = (LightningBoltPredicate)entitySubPredicate;
                components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.blocks_on_fire", predicate.f_290996_()));
                components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.stuck_entity", predicate.f_290675_(), GenericTooltipUtils::getEntityPredicateTooltip));
            } else if (entitySubPredicate instanceof FishingHookPredicate) {
                FishingHookPredicate predicate = (FishingHookPredicate)entitySubPredicate;
                components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.in_open_water", predicate.f_39757_(), GenericTooltipUtils::getBooleanTooltip));
            } else if (entitySubPredicate instanceof PlayerPredicate) {
                PlayerPredicate predicate = (PlayerPredicate)entitySubPredicate;
                components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.level", predicate.f_62245_()));
                components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, predicate.f_62246_(), GenericTooltipUtils::getGameTypeTooltip));
                components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.stats", predicate.f_62247_(), GenericTooltipUtils::getStatMatcherTooltip));
                components.addAll(GenericTooltipUtils.getRecipesTooltip(utils, pad + 1, (Object2BooleanMap<ResourceLocation>)predicate.f_62248_()));
                components.addAll(GenericTooltipUtils.getAdvancementsTooltip(utils, pad + 1, predicate.f_62249_()));
            } else if (entitySubPredicate instanceof SlimePredicate) {
                SlimePredicate predicate = (SlimePredicate)entitySubPredicate;
                components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.size", predicate.f_223418_()));
            } else {
                EntitySubPredicate.f_291594_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entitySubPredicate).result().ifPresent(element -> {
                    JsonObject jsonObject = element.getAsJsonObject();
                    if (jsonObject.has("variant")) {
                        components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.value.variant", jsonObject.getAsJsonPrimitive("variant").getAsString())));
                    } else {
                        components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.value.variant", jsonObject.toString())));
                    }
                });
            }
        });
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getItemTooltip(IClientUtils ignoredUtils, int pad, Item item) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.item", GenericTooltipUtils.value(GenericTooltipUtils.translatable(item.m_5524_(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getGameTypeTooltip(IClientUtils utils, int pad, GameType gameType) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.game_type", gameType.m_151500_()))));
    }

    @NotNull
    public static List<Component> getStatMatcherTooltip(IClientUtils utils, int pad, PlayerPredicate.StatMatcher<?> stat) {
        LinkedList<Component> components = new LinkedList<Component>();
        Holder value = stat.f_291891_();
        Object object = value.m_203334_();
        if (object instanceof Item) {
            Item item = (Item)object;
            components.addAll(GenericTooltipUtils.getItemTooltip(utils, pad, item));
        } else {
            object = value.m_203334_();
            if (object instanceof Block) {
                Block block = (Block)object;
                components.addAll(GenericTooltipUtils.getBlockTooltip(utils, pad, block));
            } else {
                components.add(GenericTooltipUtils.pad(pad, value.m_203334_().toString()));
            }
        }
        components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.keyValue(stat.f_290937_().m_12905_(), GenericTooltipUtils.toString(stat.f_291204_()))));
        return components;
    }

    @NotNull
    public static List<Component> getRecipesTooltip(IClientUtils ignoredUtils, int pad, Object2BooleanMap<ResourceLocation> recipes) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!recipes.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.recipes", new Object[0])));
            recipes.forEach((recipe, required) -> components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.keyValue(recipe.toString(), required))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getAdvancementsTooltip(IClientUtils ignoredUtils, int pad, Map<ResourceLocation, PlayerPredicate.AdvancementPredicate> predicateMap) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!predicateMap.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.advancements", new Object[0])));
            predicateMap.forEach((advancement, predicate) -> {
                components.add(GenericTooltipUtils.pad(pad + 1, advancement.toString()));
                if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
                    PlayerPredicate.AdvancementDonePredicate donePredicate = (PlayerPredicate.AdvancementDonePredicate)predicate;
                    components.add(GenericTooltipUtils.pad(pad + 2, GenericTooltipUtils.translatable("ali.property.value.done", donePredicate.f_62299_())));
                } else if (predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate) {
                    PlayerPredicate.AdvancementCriterionsPredicate criterionsPredicate = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
                    criterionsPredicate.f_62291_().forEach((criterion, state) -> components.add(GenericTooltipUtils.pad(pad + 2, GenericTooltipUtils.keyValue(criterion, state))));
                }
            });
        }
        return components;
    }

    @NotNull
    public static List<Component> getBlockPosTooltip(IClientUtils utils, int pad, BlockPos pos) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.x", pos.m_123341_()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.y", pos.m_123342_()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.z", pos.m_123343_()));
        return components;
    }

    @NotNull
    public static List<Component> getCopyOperationTooltip(IClientUtils utils, int pad, CopyNbtFunction.CopyOperation copyOperation) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.operation", new Object[0])));
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad + 1, "ali.property.value.source", copyOperation.f_80289_().f_291466_()));
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad + 1, "ali.property.value.target", copyOperation.f_80291_().f_291466_()));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.merge_strategy", copyOperation.f_80292_()));
        return components;
    }

    @NotNull
    public static Component translatable(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])Arrays.stream(args).map(GenericTooltipUtils::convertObject).toArray()).m_130940_(TEXT_STYLE);
    }

    @NotNull
    public static Component value(Object value) {
        return GenericTooltipUtils.convertObject(value).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component value(Object value, String unit) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values", (Object[])new Object[]{GenericTooltipUtils.convertObject(value), unit}).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component pair(Object value1, Object value2) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{GenericTooltipUtils.convertObject(value1), GenericTooltipUtils.convertObject(value2)});
    }

    @NotNull
    public static Component pad(int count, Object arg) {
        if (count > 0) {
            return GenericTooltipUtils.pair(Component.m_237115_((String)("ali.util.advanced_loot_info.pad." + count)), GenericTooltipUtils.convertObject(arg));
        }
        return GenericTooltipUtils.convertObject(arg);
    }

    @NotNull
    public static Component keyValue(Object key, Object value) {
        return GenericTooltipUtils.translatable("ali.util.advanced_loot_info.key_value", GenericTooltipUtils.convertObject(key), GenericTooltipUtils.value(value));
    }

    public static @Unmodifiable @NotNull List<Component> getNumberProviderTooltip(IClientUtils utils, int pad, String key, NumberProvider value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(utils.convertNumber(utils, value)))));
    }

    public static @Unmodifiable @NotNull List<Component> getIntRangeTooltip(IClientUtils utils, int pad, String key, IntRange range) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(RangeValue.rangeToString(utils.convertNumber(utils, range.f_165001_), utils.convertNumber(utils, range.f_165002_))))));
    }

    public static @Unmodifiable @NotNull List<Component> getBooleanTooltip(IClientUtils utils, int pad, String key, Boolean value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getIntegerTooltip(IClientUtils ignoredUtils, int pad, String key, int value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getLongTooltip(IClientUtils ignoredUtils, int pad, String key, Long value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getStringTooltip(IClientUtils utils, int pad, String key, String value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getFloatTooltip(IClientUtils ignoredUtils, int pad, String key, Float value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnumTooltip(IClientUtils ignoredUtils, int pad, String key, Enum<?> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.name()))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnumTooltip(IClientUtils utils, int pad, Enum<?> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(value.name())));
    }

    public static @Unmodifiable @NotNull List<Component> getResourceLocationTooltip(IClientUtils ignoredUtils, int pad, String key, ResourceLocation value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static <T> @Unmodifiable @NotNull List<Component> getBuiltInRegistryTooltip(IClientUtils utils, int pad, String key, Registry<T> registry, T value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, key, Objects.requireNonNull(registry.m_7981_(value)));
    }

    public static <T> @Unmodifiable @NotNull List<Component> getResourceKeyTooltip(IClientUtils utils, int pad, String key, ResourceKey<T> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.m_135782_()))));
    }

    public static @Unmodifiable @NotNull List<Component> getTagKeyTooltip(IClientUtils utils, int pad, String key, TagKey<?> value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, key, value.f_203868_());
    }

    public static @Unmodifiable @NotNull List<Component> getComponentTooltip(IClientUtils ignoredUtils, int pad, String key, Component component) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(component))));
    }

    @NotNull
    public static <T> List<Component> getComponentsTooltip(IClientUtils utils, int pad, String key, T value, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        List componentList = (List)mapper.apply((Object)utils, (Object)(pad + 1), value);
        if (!componentList.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            components.addAll(componentList);
        }
        return components;
    }

    @NotNull
    public static <T> List<Component> getComponentsTooltip(IClientUtils utils, int pad, String key, Optional<T> value, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        List<Component> componentList = GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, value, mapper);
        if (!componentList.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            components.addAll(componentList);
        }
        return components;
    }

    @NotNull
    public static List<Component> getMinMaxBoundsTooltip(IClientUtils ignoredUtils, int pad, String key, MinMaxBounds.Ints ints) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (ints != MinMaxBounds.Ints.f_55364_) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(ints)))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getMinMaxBoundsTooltip(IClientUtils ignoredUtils, int pad, String key, MinMaxBounds.Doubles doubles) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (doubles != MinMaxBounds.Doubles.f_154779_) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(doubles)))));
        }
        return components;
    }

    @NotNull
    public static <T> List<Component> getOptionalTooltip(IClientUtils utils, int pad, Optional<T> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(value -> (List)mapper.apply((Object)utils, (Object)pad, value)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalTooltip(IClientUtils utils, int pad, String key, Optional<T> optional, QuadFunction<IClientUtils, Integer, String, T, List<Component>> mapper) {
        return optional.map(value -> (List)mapper.apply(utils, pad, key, value)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalHolderTooltip(IClientUtils utils, int pad, Optional<Holder<T>> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(holder -> GenericTooltipUtils.getHolderTooltip(utils, pad, holder, mapper)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalHolderSetTooltip(IClientUtils utils, int pad, String key, Optional<HolderSet<T>> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(holderSet -> GenericTooltipUtils.getHolderSetTooltip(utils, pad, key, holderSet, mapper)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getHolderTooltip(IClientUtils utils, int pad, Holder<T> holder, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return (List)mapper.apply((Object)utils, (Object)pad, holder.m_203334_());
    }

    @NotNull
    public static <T> List<Component> getHolderSetTooltip(IClientUtils utils, int pad, String key, HolderSet<T> holderSet, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        Either either = holderSet.m_203440_();
        Optional left = either.left();
        Optional right = either.right();
        if (left.isPresent() || !right.orElse(List.of()).isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        }
        left.ifPresent(tagKey -> components.addAll(GenericTooltipUtils.getTagKeyTooltip(utils, pad + 1, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, holder, mapper)));
            }
        });
        return components;
    }

    @NotNull
    public static <T> List<Component> getCollectionTooltip(IClientUtils utils, int pad, String key, Collection<T> values, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!values.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            values.forEach(value -> components.addAll((Collection)mapper.apply((Object)utils, (Object)(pad + 1), value)));
        }
        return components;
    }

    @NotNull
    private static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.m_293284_();
        Optional max = doubles.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    private static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.m_293284_();
        Optional max = ints.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static MutableComponent convertObject(@Nullable Object object) {
        if (object instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)object;
            return component;
        }
        if (object != null) {
            return Component.m_237113_((String)object.toString());
        }
        return Component.m_237113_((String)"null");
    }

    @FunctionalInterface
    public static interface QuadFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

