/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    private TooltipUtils() {
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getChance(IClientUtils utils, List<LootItemCondition> conditions, float rawChance) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> chance = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (LootItemCondition condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getCount(IClientUtils utils, List<LootItemFunction> functions) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> count = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static ItemStack getItemStack(IClientUtils utils, LootPoolEntryContainer entry, Item item) {
        ItemStack itemStack = item.m_7968_();
        if (entry.f_79636_.isEmpty() && entry instanceof LootPoolSingletonContainer) {
            LootPoolSingletonContainer container = (LootPoolSingletonContainer)entry;
            for (LootItemFunction function : container.f_79677_) {
                itemStack = utils.applyItemStackModifier(utils, function, itemStack);
            }
        }
        return itemStack;
    }

    public static void applyRandomChance(IClientUtils utils, LootItemRandomChanceCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(condition.f_81921_());
            }
        }
    }

    public static void applyRandomChanceWithLooting(IClientUtils utils, LootItemRandomChanceWithLootingCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        Holder enchantment = Holder.m_205709_((Object)Enchantments.f_44982_);
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.f_81953_());
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                entry.getValue().multiply(condition.f_81953_() + (float)entry.getKey().intValue() * condition.f_81954_());
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.f_81953_());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.f_81953_() + (float)level * condition.f_81954_()));
            }
        }
    }

    public static void applyTableBonus(IClientUtils utils, BonusLevelTableCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        block2: {
            Holder enchantment;
            block3: {
                enchantment = condition.f_81507_();
                if (condition.f_81508_().isEmpty()) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(((Float)condition.f_81508_().get(0)).floatValue());
                if (condition.f_81508_().size() <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.f_81508_().size()) continue;
                    entry.getValue().multiply(((Float)condition.f_81508_().get(level)).floatValue());
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(((Float)condition.f_81508_().get(0)).floatValue());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_() && level < condition.f_81508_().size(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(((Float)condition.f_81508_().get(level)).floatValue()));
            }
        }
    }

    public static void applySetCount(IClientUtils utils, SetItemCountFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        if (function.f_80676_.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.f_165407_) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.f_80997_));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.f_80997_));
                }
            }
        }
    }

    public static void applyBonus(IClientUtils utils, ApplyBonusCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block4: {
            if (!function.f_80676_.isEmpty()) break block4;
            Holder enchantment = function.f_79899_;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IClientUtils utils, LimitCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> bonusCount) {
        if (function.f_80676_.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.f_80635_.f_165001_), utils.convertNumber(utils, function.f_80635_.f_165002_));
                }
            }
        }
    }

    public static void applyLootingEnchant(IClientUtils utils, LootingEnchantFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block5: {
            if (!function.f_80676_.isEmpty()) break block5;
            Holder enchantment = Holder.m_205709_((Object)Enchantments.f_44982_);
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.f_80776_).multiply(entry.getKey().intValue()));
                    if (function.f_80777_ <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.f_80777_));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.m_203334_()).m_6586_(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.f_80776_).multiply(level));
                    if (function.f_80777_ > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.f_80777_));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static ItemStack applyEnchantRandomlyItemStackModifier(IClientUtils utils, EnchantRandomlyFunction function, ItemStack itemStack) {
        if (itemStack.m_41792_() && function.f_80676_.isEmpty()) {
            List<Holder.Reference> list;
            boolean isBook = itemStack.m_150930_(Items.f_42517_);
            ItemStack finalItemStack = itemStack;
            Optional<HolderSet.Direct> enchantments = function.f_80415_;
            if (enchantments.isEmpty() && (list = BuiltInRegistries.f_256876_.m_203611_().filter(ref -> ((Enchantment)ref.m_203334_()).m_6592_()).filter(ref -> isBook || ((Enchantment)ref.m_203334_()).m_6081_(finalItemStack)).toList()).size() == 1) {
                enchantments = Optional.of(HolderSet.m_205809_((Holder[])new Holder[]{(Holder)list.get(0)}));
            }
            if (enchantments.isPresent() && ((HolderSet)enchantments.get()).m_203632_() == 1 && ((Enchantment)((HolderSet)enchantments.get()).m_203662_(0).m_203334_()).m_44702_() == ((Enchantment)((HolderSet)enchantments.get()).m_203662_(0).m_203334_()).m_6586_()) {
                itemStack.m_41663_((Enchantment)((HolderSet)enchantments.get()).m_203662_(0).m_203334_(), ((Enchantment)((HolderSet)enchantments.get()).m_203662_(0).m_203334_()).m_6586_());
            } else if (isBook) {
                itemStack = Items.f_42690_.m_7968_();
            }
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack applyEnchantWithLevelsItemStackModifier(IClientUtils utils, EnchantWithLevelsFunction function, ItemStack itemStack) {
        if (itemStack.m_41792_() && function.f_80676_.isEmpty() && itemStack.m_150930_(Items.f_42517_)) {
            itemStack = Items.f_42690_.m_7968_();
        }
        return itemStack;
    }

    public static ItemStack applySetAttributesItemStackModifier(IClientUtils utils, SetAttributesFunction function, ItemStack itemStack) {
        if (function.f_80676_.isEmpty()) {
            for (SetAttributesFunction.Modifier modifier : function.f_80831_) {
                UUID id = modifier.f_80851_().orElse(UUID.randomUUID());
                if (modifier.f_80852_().size() != 1 || modifier.f_80850_().m_142587_() != NumberProviders.f_165731_) continue;
                EquipmentSlot equipmentSlot = (EquipmentSlot)Util.m_214621_((List)modifier.f_80852_(), (RandomSource)RandomSource.m_216327_());
                ConstantValue value = (ConstantValue)modifier.f_80850_();
                itemStack.m_41643_((Attribute)modifier.f_80848_().m_203334_(), new AttributeModifier(id, modifier.f_80847_(), (double)value.m_142688_(null), modifier.f_80849_()), equipmentSlot);
            }
        }
        return itemStack;
    }

    public static ItemStack applySetNameItemStackModifier(IClientUtils utils, SetNameFunction function, ItemStack itemStack) {
        if (function.f_80676_.isEmpty() && function.f_81123_.isPresent()) {
            itemStack.m_41714_((Component)function.f_81123_.get());
        }
        return itemStack;
    }

    public static ItemStack applyItemStackModifier(IClientUtils utils, LootItemFunction function, ItemStack itemStack) {
        if (function instanceof LootItemConditionalFunction) {
            LootItemConditionalFunction conditional = (LootItemConditionalFunction)function;
            if (!conditional.f_80676_.isEmpty()) {
                return itemStack;
            }
        }
        itemStack = (ItemStack)function.apply((Object)itemStack, null);
        return itemStack;
    }

    private static void calculateCount(ApplyBonusCount function, RangeValue value, int level) {
        if (function.f_79900_ instanceof ApplyBonusCount.OreDrops) {
            if (level > 0) {
                value.multiplyMax(level + 1);
            }
        } else {
            ApplyBonusCount.Formula formula = function.f_79900_;
            if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
                ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
                value.addMax(binomialWithBonusCount.f_79948_() + level);
            } else {
                formula = function.f_79900_;
                if (formula instanceof ApplyBonusCount.UniformBonusCount) {
                    ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
                    if (level > 0) {
                        value.addMax(uniformBonusCount.f_80013_() * level);
                    }
                }
            }
        }
    }
}

