/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.google.common.collect.Lists;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.plugin.client.WidgetUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class DynamicWidget
implements IEntryWidget {
    private final List<Component> components = Lists.newArrayList();
    private final Rect bounds;
    private final IWidget widget;
    private final LootPoolEntryContainer entry;

    public DynamicWidget(IWidgetUtils utils, LootPoolEntryContainer entry, int x, int y, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this.widget = WidgetUtils.getDynamicWidget(x, y, (DynamicLoot)entry, sumWeight);
        this.bounds = this.widget.getRect();
        this.entry = entry;
    }

    public void appendTooltip(Component text) {
        this.components.add(text);
    }

    @Override
    public Rect getRect() {
        return this.bounds;
    }

    @Override
    public LootPoolEntryContainer getLootEntry() {
        return this.entry;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.widget.render(guiGraphics, mouseX, mouseY);
    }

    @Override
    public List<Component> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<Component> components = new LinkedList<Component>(this.widget.getTooltipComponents(mouseX, mouseY));
        components.addAll(this.components);
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return this.widget.mouseClicked(mouseX, mouseY, button);
    }

    @NotNull
    public static Rect getBounds(IClientUtils utils, LootPoolEntryContainer entry, int x, int y) {
        return new Rect(x, y, 7, 18);
    }
}

