/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ItemCollectorUtils {
    @NotNull
    public static List<Item> collectLootTable(IServerUtils utils, LootTable lootTable) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPool pool : lootTable.f_79109_) {
            result.addAll(ItemCollectorUtils.collectLootPool(utils, pool));
        }
        result.addAll(lootTable.f_79110_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<Item> collectLootPool(IServerUtils utils, LootPool pool) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPoolEntryContainer entry : pool.f_79023_) {
            result.addAll(utils.collectItems(utils, entry));
        }
        result.addAll(pool.f_79024_.stream().map(c -> utils.collectItems(utils, List.copyOf(result), c)).flatMap(Collection::stream).toList());
        result.addAll(pool.f_79026_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectItems(IServerUtils utils, LootItem entry) {
        LinkedList<Item> result = new LinkedList<Item>(List.of((Item)entry.f_79564_.m_203334_()));
        result.addAll(entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectTags(IServerUtils utils, TagEntry entry) {
        LinkedList<Item> result = new LinkedList<Item>(BuiltInRegistries.f_257033_.m_203431_(entry.f_79821_).map(tag -> tag.m_203614_().map(Holder::m_203334_).toList()).orElse(List.of()));
        result.addAll(entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<Item> collectComposite(IServerUtils utils, CompositeEntryBase entry) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPoolEntryContainer child : entry.f_79428_) {
            result.addAll(utils.collectItems(utils, child));
        }
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectSingleton(IServerUtils utils, LootPoolSingletonContainer entry) {
        return entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.of(), f)).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<Item> collectReference(IServerUtils utils, LootTableReference entry) {
        LinkedList<Item> result = new LinkedList<Item>();
        LootTable lootTable = utils.getLootTable(entry.f_79754_);
        if (lootTable != null) {
            result.addAll(ItemCollectorUtils.collectLootTable(utils, lootTable));
            result.addAll(entry.f_79677_.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        }
        return result;
    }

    @NotNull
    public static List<Item> collectFurnaceSmelt(IServerUtils utils, List<Item> items, SmeltItemFunction function) {
        ServerLevel level = utils.getServerLevel();
        if (level != null) {
            return items.stream().map(i -> level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{i.m_7968_()}), (Level)level).map(l -> List.of(((SmeltingRecipe)l.f_291008_()).m_8043_(null).m_41720_())).orElse(List.of())).flatMap(Collection::stream).toList();
        }
        return List.of();
    }
}

