/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SheepPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import org.jetbrains.annotations.NotNull;

public class EntitySubPredicateTooltipUtils {
    @NotNull
    public static ITooltipNode getLightningBoltPredicateTooltip(IServerUtils utils, LightningBoltPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.lightning_bolt", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.blocks_on_fire", predicate.blocksSetOnFire()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.stuck_entity", predicate.entityStruck(), GenericTooltipUtils::getEntityPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getFishingHookPredicateTooltip(IServerUtils utils, FishingHookPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.fishing_hook", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.in_open_water", predicate.inOpenWater(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPlayerPredicateTooltip(IServerUtils utils, PlayerPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.player", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", predicate.level()));
        tooltip.add(GenericTooltipUtils.getGameTypePredicateTooltip(utils, "ali.property.branch.game_types", predicate.gameType()));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.stats", predicate.stats(), GenericTooltipUtils::getStatMatcherTooltip));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.recipes", predicate.recipes(), GenericTooltipUtils::getRecipeEntryTooltip));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.advancements", predicate.advancements(), GenericTooltipUtils::getAdvancementEntryTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.looking_at", predicate.lookingAt(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.input", predicate.input(), GenericTooltipUtils::getInputPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSlimePredicateTooltip(IServerUtils utils, SlimePredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.slime", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.size", predicate.size()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getRaiderPredicateTooltip(IServerUtils utils, RaiderPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.raider", new Object[0]));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_raid", predicate.hasRaid()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.is_captain", predicate.isCaptain()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSheepPredicateTooltip(IServerUtils utils, SheepPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.sheep", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.sheared", predicate.sheared(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }
}

