/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.compatibility.jei.JeiBlockLoot;
import com.yanny.ali.compatibility.jei.JeiEntityLoot;
import com.yanny.ali.compatibility.jei.JeiGameplayLoot;
import com.yanny.ali.compatibility.jei.JeiTradeLoot;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@JeiPlugin
public class JeiCompatibility
implements IModPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<LootCategory<class_2248>, JeiBlockLoot> blockCategories = new LinkedHashMap<LootCategory<class_2248>, JeiBlockLoot>();
    private final Map<LootCategory<class_1299<?>>, JeiEntityLoot> entityCategories = new LinkedHashMap();
    private final Map<LootCategory<class_2960>, JeiGameplayLoot> gameplayCategories = new LinkedHashMap<LootCategory<class_2960>, JeiGameplayLoot>();
    private final Map<LootCategory<class_2960>, JeiTradeLoot> tradeCategories = new LinkedHashMap<LootCategory<class_2960>, JeiTradeLoot>();

    public void onRuntimeUnavailable() {
        this.blockCategories.clear();
        this.entityCategories.clear();
        this.gameplayCategories.clear();
        this.tradeCategories.clear();
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.blockCategories.clear();
        this.entityCategories.clear();
        this.gameplayCategories.clear();
        this.tradeCategories.clear();
        this.blockCategories.putAll(config.blockCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiBlockLoot::new)));
        this.entityCategories.putAll(config.entityCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiEntityLoot::new)));
        this.gameplayCategories.putAll(config.gameplayCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiGameplayLoot::new)));
        this.tradeCategories.putAll(config.tradeCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiTradeLoot::new)));
        this.blockCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.entityCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.gameplayCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.tradeCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        CompletableFuture<Pair<Map<class_2960, IDataNode>, Map<class_2960, IDataNode>>> futureData = PluginManager.CLIENT_REGISTRY.getCurrentDataFuture();
        if (futureData.isDone()) {
            LOGGER.info("Data already received, processing instantly.");
        } else {
            LOGGER.info("Blocking this thread until all data are received!");
        }
        try {
            Pair<Map<class_2960, IDataNode>, Map<class_2960, IDataNode>> pair = futureData.get();
            this.registerData(registration, (Map)pair.getLeft(), (Map)pair.getRight());
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof TimeoutException) {
                futureData.cancel(true);
                PluginManager.CLIENT_REGISTRY.clearLootData();
                LOGGER.error("Failed to received data: Inactivity timeout occurred. Registration aborted!");
            } else {
                LOGGER.error("Failed to finish registering data with error {}", (Object)cause.getMessage());
                cause.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.error("Failed to finish registering data with unexpected error {}", (Object)e.getMessage());
        }
    }

    private void registerData(IRecipeRegistration registration, Map<class_2960, IDataNode> lootData, Map<class_2960, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        class_638 level = class_310.method_1551().field_1687;
        LOGGER.info("Adding loot information to JEI");
        if (level != null) {
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap gameplayRecipeTypes = new HashMap();
            HashMap tradeRecipeTypes = new HashMap();
            GenericUtils.processData(level, clientRegistry, config, lootData, tradeData, (node, location, block, outputs) -> {
                RecipeType recipeType = null;
                for (JeiBlockLoot recipeCategory : this.blockCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(block)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    blockRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new BlockLootType((class_2248)block, (IDataNode)node, Collections.emptyList(), (List<class_1799>)outputs));
                }
            }, (node, location, entity, outputs) -> {
                RecipeType recipeType = null;
                for (JeiEntityLoot recipeCategory : this.entityCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(entity)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    entityRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new EntityLootType((class_1299<?>)entity, (class_2960)location, (IDataNode)node, Collections.emptyList(), (List<class_1799>)outputs));
                }
            }, (node, location, outputs) -> {
                RecipeType recipeType = null;
                for (JeiGameplayLoot recipeCategory : this.gameplayCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(location)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    gameplayRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new GameplayLootType((IDataNode)node, location.method_12832(), Collections.emptyList(), (List<class_1799>)outputs));
                }
            }, (node, location, inputs, outputs) -> {
                RecipeType recipeType = null;
                for (JeiTradeLoot recipeCategory : this.tradeCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(location)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new TradeLootType((IDataNode)node, location.method_12832(), (List<class_1799>)inputs, (List<class_1799>)outputs));
                }
            }, (node, location, inputs, outputs) -> {
                RecipeType recipeType = null;
                for (JeiTradeLoot recipeCategory : this.tradeCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(location)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new TradeLootType((IDataNode)node, location.method_12832(), (List<class_1799>)inputs, (List<class_1799>)outputs));
                }
            });
            for (Map.Entry entry : blockRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : entityRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : gameplayRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : tradeRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
        } else {
            LOGGER.warn("JEI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    public class_2960 getPluginUid() {
        return Utils.modLoc("jei_plugin");
    }

    private static <T, U, V extends IType> T createCategory(IGuiHelper guiHelper, LootCategory<U> e, LootConstructor<T, U, V> constructor) {
        RecipeType recipeType = RecipeType.create((String)e.getKey().method_12836(), (String)e.getKey().method_12832(), RecipeHolder.class);
        class_5250 title = class_2561.method_43471((String)("emi.category." + e.getKey().method_12836() + "." + e.getKey().method_12832().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e, (class_2561)title, guiHelper.createDrawableItemStack(e.getIcon().method_7854()));
    }

    @NotNull
    private static <T, U, V extends IType> Collector<LootCategory<U>, ?, Map<LootCategory<U>, T>> getCollector(IGuiHelper guiHelper, LootConstructor<T, U, V> supplier) {
        return Collectors.toMap(e -> e, e -> JeiCompatibility.createCategory(guiHelper, e, supplier), (a, b) -> a, LinkedHashMap::new);
    }

    @FunctionalInterface
    private static interface LootConstructor<T, U, V extends IType> {
        public T construct(IGuiHelper var1, RecipeType<RecipeHolder<V>> var2, LootCategory<U> var3, class_2561 var4, IDrawable var5);
    }
}

