/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliClientRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4048;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GenericUtils {
    private static final class_2960 TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = class_310.method_1551().field_1772.method_1727("...");

    public static void renderEntity(class_1297 entity, Rect bounds, int fullWidth, class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        class_4587 poseStack = guiGraphics.method_51448();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.method_4486());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.method_4502());
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_25293(TEXTURE_LOC, bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0.0f, 36.0f, 36, 36, 256, 256);
            guiGraphics.method_44379(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            class_4048 dimensions = entity.method_5864().method_18386();
            class_490.method_2486((class_332)guiGraphics, (int)(-screenX + bounds.x()), (int)(-screenY + bounds.y()), (int)(screenX + bounds.right()), (int)(screenY + bounds.bottom()), (int)((int)Math.min(20.0f / dimensions.comp_2186(), 20.0f / dimensions.comp_2185())), (float)0.0625f, (float)mouseX, (float)mouseY, (class_1309)livingEntity);
            guiGraphics.method_44380();
            guiGraphics.method_51448().method_22909();
        }
    }

    @NotNull
    public static class_2561 ellipsis(String text, String fallback, int maxWidth) {
        class_327 font = class_310.method_1551().field_1772;
        text = class_2477.method_10517().method_4679(text, GenericUtils.getFallbackText(fallback));
        if (font.method_1727(text) > maxWidth) {
            int index = 20;
            while (font.method_1727(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return class_2561.method_43470((String)(text.substring(0, index) + "..."));
        }
        return class_2561.method_43470((String)text);
    }

    public static void processData(class_638 level, AliClientRegistry clientRegistry, AliConfig config, Map<class_2960, IDataNode> lootData, Map<class_2960, IDataNode> tradeData, QuadConsumer<IDataNode, class_2960, class_2248, List<class_1799>> blockConsumer, QuadConsumer<IDataNode, class_2960, class_1299<?>, List<class_1799>> entityConsumer, TriConsumer<IDataNode, class_2960, List<class_1799>> gameplayConsumer, QuadConsumer<IDataNode, class_2960, List<class_1799>, List<class_1799>> traderConsumer, QuadConsumer<IDataNode, class_2960, List<class_1799>, List<class_1799>> wanderingTraderConsumer) {
        List<class_1799> outputs;
        List<class_1799> inputs;
        IDataNode tradeEntry;
        Object location;
        for (class_2248 block : class_7923.field_41175) {
            class_5321 class_53212 = block.method_26162();
            if (class_53212 == null) continue;
            location = class_53212.method_29177();
            IDataNode lootEntry = lootData.get(location);
            List<class_1799> outputs2 = clientRegistry.getLootItems((class_2960)location);
            if (lootEntry == null || outputs2 == null) continue;
            blockConsumer.accept(lootEntry, (class_2960)location, block, outputs2);
            lootData.remove(location);
        }
        for (class_1299 entityType : class_7923.field_41177) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)class_7923.field_41177.method_10221((Object)entityType)))) {
                lootData.remove(entityType.method_16351());
                continue;
            }
            List<class_1297> list = clientRegistry.createEntities(entityType, (class_1937)level);
            for (class_1297 entity : list) {
                class_1308 mob;
                class_5321 resourceKey;
                if (!(entity instanceof class_1308) || (resourceKey = (mob = (class_1308)entity).method_5989()) == null) continue;
                class_2960 location2 = resourceKey.method_29177();
                IDataNode lootEntry = lootData.get(location2);
                List<class_1799> outputs3 = clientRegistry.getLootItems(location2);
                if (lootEntry != null && outputs3 != null) {
                    entityConsumer.accept(lootEntry, location2, entityType, outputs3);
                }
                lootData.remove(location2);
            }
        }
        for (Map.Entry<class_2960, IDataNode> entry : lootData.entrySet()) {
            class_2960 class_29602 = entry.getKey();
            List<class_1799> outputs4 = clientRegistry.getLootItems(class_29602);
            if (outputs4 == null) continue;
            gameplayConsumer.accept(entry.getValue(), entry.getKey(), outputs4);
        }
        lootData.clear();
        List<Map.Entry> entries = class_7923.field_41195.method_29722().stream().sorted(Comparator.comparing(a -> ((class_5321)a.getKey()).method_29177().method_12832())).toList();
        for (Map.Entry entry : entries) {
            location = ((class_5321)entry.getKey()).method_29177();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems((class_2960)location).stream().map(class_1792::method_7854).toList();
            outputs = clientRegistry.getTradeOutputItems((class_2960)location).stream().map(class_1792::method_7854).toList();
            traderConsumer.accept(tradeEntry, (class_2960)location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (class_2960)entry.getKey();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems((class_2960)location).stream().map(class_1792::method_7854).toList();
            outputs = clientRegistry.getTradeOutputItems((class_2960)location).stream().map(class_1792::method_7854).toList();
            wanderingTraderConsumer.accept(tradeEntry, (class_2960)location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }
}

