/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.Client;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.Server;
import com.yanny.ali.network.SyncLootTableMessage;
import com.yanny.ali.network.SyncTradeMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    public static DistHolder<AbstractClient, AbstractServer> registerLootInfoPropagator() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return NetworkUtils.registerClientLootInfoPropagator();
        }
        return NetworkUtils.registerServerLootInfoPropagator();
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerClientLootInfoPropagator() {
        Client client = new Client();
        Server server = new Server();
        PayloadTypeRegistry.playS2C().register(SyncLootTableMessage.TYPE, SyncLootTableMessage.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncTradeMessage.TYPE, SyncTradeMessage.CODEC);
        PayloadTypeRegistry.playS2C().register(ClearMessage.TYPE, ClearMessage.CODEC);
        PayloadTypeRegistry.playS2C().register(DoneMessage.TYPE, DoneMessage.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(SyncLootTableMessage.TYPE, client::onLootInfo);
        ClientPlayNetworking.registerGlobalReceiver(SyncTradeMessage.TYPE, client::onTradeInfo);
        ClientPlayNetworking.registerGlobalReceiver(ClearMessage.TYPE, client::onClear);
        ClientPlayNetworking.registerGlobalReceiver(DoneMessage.TYPE, client::onDone);
        return new DistHolder<AbstractClient, AbstractServer>(client, server);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerServerLootInfoPropagator() {
        Server server = new Server();
        PayloadTypeRegistry.playS2C().register(SyncLootTableMessage.TYPE, SyncLootTableMessage.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncTradeMessage.TYPE, SyncTradeMessage.CODEC);
        PayloadTypeRegistry.playS2C().register(ClearMessage.TYPE, ClearMessage.CODEC);
        PayloadTypeRegistry.playS2C().register(DoneMessage.TYPE, DoneMessage.CODEC);
        return new DistHolder<Object, Server>(null, server);
    }
}

