/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_65;
import net.minecraft.class_6880;
import net.minecraft.class_69;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;

public class NodeUtils {
    public static int getTotalWeight(List<class_79> entries) {
        int sum = 0;
        for (class_79 entry : entries) {
            if (entry instanceof class_85) {
                class_85 singletonContainer = (class_85)entry;
                sum += singletonContainer.field_995;
                continue;
            }
            if (!(entry instanceof class_69)) continue;
            class_69 compositeEntryBase = (class_69)entry;
            if (entry instanceof class_65) {
                ++sum;
                continue;
            }
            sum += NodeUtils.getTotalWeight(compositeEntryBase.field_982);
        }
        return sum;
    }

    @NotNull
    public static List<class_2561> toComponents(List<ITooltipNode> tooltip, int pad, boolean showAdvancedTooltip) {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        for (ITooltipNode node : tooltip) {
            components.addAll(NodeUtils.toComponents(node, pad, showAdvancedTooltip));
        }
        return components;
    }

    @NotNull
    public static List<class_2561> toComponents(ITooltipNode tooltip, int pad, boolean showAdvancedTooltip) {
        return tooltip.getComponents(pad, showAdvancedTooltip);
    }

    public static void processLootModifier(IServerUtils utils, ILootModifier<?> modifier, LootTableNode node) {
        List<IOperation> operations = modifier.getOperations();
        for (IOperation operation : operations) {
            Predicate<class_1799> predicate;
            Object object;
            if (operation instanceof IOperation.AddOperation) {
                IOperation.AddOperation addOperation = (IOperation.AddOperation)operation;
                node.addChildren(addOperation.node());
                continue;
            }
            if (operation instanceof IOperation.RemoveOperation) {
                IOperation.RemoveOperation removeOperation = (IOperation.RemoveOperation)operation;
                object = removeOperation.predicate();
                Predicate<class_1799> predicate2 = object;
                NodeUtils.removeItem(node, predicate2);
                continue;
            }
            if (!(operation instanceof IOperation.ReplaceOperation)) continue;
            IOperation.ReplaceOperation replaceOperation = (IOperation.ReplaceOperation)operation;
            try {
                object = replaceOperation.predicate();
                predicate = object;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object factory = object = replaceOperation.factory();
            NodeUtils.replaceItem(utils, node, (Function<IDataNode, List<IDataNode>>)factory, predicate);
        }
    }

    private static void removeItem(IDataNode node, Predicate<class_1799> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> {
                if (n instanceof IItemNode) {
                    IItemNode itemNode = (IItemNode)((Object)n);
                    return NodeUtils.predicateEither(itemNode, predicate);
                }
                NodeUtils.removeItem(n, predicate);
                return false;
            });
            NodeUtils.removeEmptyNodes(node);
        }
    }

    private static void replaceItem(IServerUtils utils, IDataNode node, Function<IDataNode, List<IDataNode>> factory, Predicate<class_1799> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            ArrayList nodes = new ArrayList();
            listNode.nodes().replaceAll(n -> {
                IItemNode itemNode;
                if (n instanceof IItemNode && NodeUtils.predicateEither(itemNode = (IItemNode)((Object)n), predicate)) {
                    List result = (List)factory.apply((IDataNode)n);
                    if (result.size() > 1) {
                        nodes.addAll(result.subList(1, result.size()));
                    }
                    return (IDataNode)result.getFirst();
                }
                if (n instanceof ListNode) {
                    ListNode l = (ListNode)n;
                    NodeUtils.replaceItem(utils, l, factory, predicate);
                }
                return n;
            });
            nodes.forEach(listNode::addChildren);
        }
    }

    private static boolean hasItems(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            return listNode.nodes().stream().anyMatch(NodeUtils::hasItems);
        }
        return node instanceof IItemNode;
    }

    private static void removeEmptyNodes(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> !NodeUtils.hasItems(n));
        }
    }

    private static <T extends class_1935> boolean predicateEither(IItemNode itemNode, Predicate<class_1799> predicate) {
        return (Boolean)itemNode.getModifiedItem().map(predicate::test, tagKey -> {
            class_2378 registry = (class_2378)class_7923.field_41167.method_10223(tagKey.comp_326().method_29177());
            if (registry != null) {
                return registry.method_40266(tagKey).map(holders -> holders.method_40239().map(class_6880::comp_349)).orElse(Stream.of(new class_1935[0])).map(i -> i.method_8389().method_7854()).allMatch(predicate);
            }
            return false;
        });
    }
}

