/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ComponentTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_137;
import net.minecraft.class_152;
import net.minecraft.class_1799;
import net.minecraft.class_2022;
import net.minecraft.class_2025;
import net.minecraft.class_2035;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3735;
import net.minecraft.class_3837;
import net.minecraft.class_42;
import net.minecraft.class_4550;
import net.minecraft.class_4551;
import net.minecraft.class_4552;
import net.minecraft.class_4553;
import net.minecraft.class_4559;
import net.minecraft.class_4965;
import net.minecraft.class_5321;
import net.minecraft.class_5658;
import net.minecraft.class_6404;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7376;
import net.minecraft.class_7383;
import net.minecraft.class_8129;
import net.minecraft.class_94;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueTooltipUtils {
    @NotNull
    public static IKeyTooltipNode getFormulaTooltip(IServerUtils utils, class_94.class_96 formula) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, formula.method_466().comp_1850());
        if (formula instanceof class_94.class_95) {
            class_94.class_95 binomialWithBonusCount = (class_94.class_95)formula;
            tooltip.add(utils.getValueTooltip(utils, binomialWithBonusCount.comp_1848()).build("ali.property.value.extra_rounds"));
            tooltip.add(utils.getValueTooltip(utils, Float.valueOf(binomialWithBonusCount.comp_1849())).build("ali.property.value.probability"));
        } else if (formula instanceof class_94.class_100) {
            class_94.class_100 uniformBonusCount = (class_94.class_100)formula;
            tooltip.add(utils.getValueTooltip(utils, uniformBonusCount.comp_1852()).build("ali.property.value.bonus_multiplier"));
        }
        return tooltip;
    }

    @NotNull
    public static IKeyTooltipNode getPropertyTooltip(IServerUtils utils, class_2769<?> property) {
        return utils.getValueTooltip(utils, property.method_11899());
    }

    @NotNull
    public static IKeyTooltipNode getModifierTooltip(IServerUtils utils, class_137.class_138 modifier) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, modifier.comp_1859()).build("ali.property.value.name")).add(utils.getValueTooltip(utils, modifier.comp_1860()).build("ali.property.value.attribute")).add(utils.getValueTooltip(utils, modifier.comp_1861()).build("ali.property.value.operation")).add(utils.getValueTooltip(utils, modifier.comp_1862()).build("ali.property.value.amount")).add(utils.getValueTooltip(utils, modifier.comp_1864()).build("ali.property.value.uuid")).add(utils.getValueTooltip(utils, modifier.comp_1863()).build("ali.property.branch.equipment_slots"));
    }

    @NotNull
    public static IKeyTooltipNode getUUIDTooltip(IServerUtils ignoredUtils, UUID uuid) {
        return ValueTooltipNode.value(uuid);
    }

    @NotNull
    public static IKeyTooltipNode getPairTooltip(IServerUtils utils, Pair<?, ?> pair) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, pair.getFirst());
        tooltip.add(utils.getValueTooltip(utils, pair.getSecond()).build("ali.property.value.color"));
        return tooltip;
    }

    @NotNull
    public static IKeyTooltipNode getStatePropertiesPredicateTooltip(IServerUtils utils, class_4559 propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, propertiesPredicate.comp_1830(), GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    @NotNull
    public static IKeyTooltipNode getDamageSourcePredicateTooltip(IServerUtils utils, class_2022 damagePredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, damagePredicate.comp_1740()).build("ali.property.branch.tags")).add(utils.getValueTooltip(utils, damagePredicate.comp_1741()).build("ali.property.branch.direct_entity")).add(utils.getValueTooltip(utils, damagePredicate.comp_1742()).build("ali.property.branch.source_entity"));
    }

    @NotNull
    public static <T> IKeyTooltipNode getTagPredicateTooltip(IServerUtils ignoredUtils, class_8129<T> tagPredicate) {
        return ValueTooltipNode.keyValue(tagPredicate.comp_1836().comp_327().toString(), Boolean.toString(tagPredicate.comp_1837()));
    }

    @NotNull
    public static IKeyTooltipNode getEntityPredicateTooltip(IServerUtils utils, class_2048 entityPredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, entityPredicate.comp_1761()).build("ali.property.branch.entity_types")).add(utils.getValueTooltip(utils, entityPredicate.comp_1762()).build("ali.property.branch.distance_to_player")).add(utils.getValueTooltip(utils, entityPredicate.comp_1763()).build("ali.property.branch.location")).add(utils.getValueTooltip(utils, entityPredicate.comp_1764()).build("ali.property.branch.stepping_on_location")).add(utils.getValueTooltip(utils, entityPredicate.comp_1765()).build("ali.property.branch.mob_effects")).add(utils.getValueTooltip(utils, entityPredicate.comp_1766()).build("ali.property.value.nbt")).add(utils.getValueTooltip(utils, entityPredicate.comp_1767()).build("ali.property.branch.entity_flags")).add(utils.getValueTooltip(utils, entityPredicate.comp_1768()).build("ali.property.branch.entity_equipment")).add(utils.getValueTooltip(utils, entityPredicate.comp_1769()).build("ali.property.branch.entity_sub_predicate")).add(utils.getValueTooltip(utils, entityPredicate.comp_1770()).build("ali.property.branch.vehicle")).add(utils.getValueTooltip(utils, entityPredicate.comp_1771()).build("ali.property.branch.passenger")).add(utils.getValueTooltip(utils, entityPredicate.comp_1772()).build("ali.property.branch.targeted_entity")).add(utils.getValueTooltip(utils, entityPredicate.comp_1773()).build("ali.property.value.team"));
    }

    @NotNull
    public static IKeyTooltipNode getEntityTypePredicateTooltip(IServerUtils utils, class_2050 entityTypePredicate) {
        return utils.getValueTooltip(utils, entityTypePredicate.comp_1775());
    }

    @NotNull
    public static IKeyTooltipNode getDistancePredicateTooltip(IServerUtils utils, class_2025 distancePredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, distancePredicate.comp_1743()).build("ali.property.value.x")).add(utils.getValueTooltip(utils, distancePredicate.comp_1744()).build("ali.property.value.y")).add(utils.getValueTooltip(utils, distancePredicate.comp_1745()).build("ali.property.value.z")).add(utils.getValueTooltip(utils, distancePredicate.comp_1746()).build("ali.property.value.horizontal")).add(utils.getValueTooltip(utils, distancePredicate.comp_1747()).build("ali.property.value.absolute"));
    }

    @NotNull
    public static IKeyTooltipNode getLocationPredicateTooltip(IServerUtils utils, class_2090 locationPredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, locationPredicate.comp_1794()).build("ali.property.branch.position")).add(utils.getValueTooltip(utils, locationPredicate.comp_1795()).build("ali.property.value.biome")).add(utils.getValueTooltip(utils, locationPredicate.comp_1796()).build("ali.property.value.structure")).add(utils.getValueTooltip(utils, locationPredicate.comp_1797()).build("ali.property.value.dimension")).add(utils.getValueTooltip(utils, locationPredicate.comp_1798()).build("ali.property.value.smokey")).add(utils.getValueTooltip(utils, locationPredicate.comp_1799()).build("ali.property.value.light")).add(utils.getValueTooltip(utils, locationPredicate.comp_1800()).build("ali.property.branch.block_predicate")).add(utils.getValueTooltip(utils, locationPredicate.comp_1801()).build("ali.property.branch.fluid_predicate"));
    }

    @NotNull
    public static IKeyTooltipNode getPositionPredicateTooltip(IServerUtils utils, class_2090.class_8747 positionPredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, positionPredicate.comp_1802()).build("ali.property.value.x")).add(utils.getValueTooltip(utils, positionPredicate.comp_1803()).build("ali.property.value.y")).add(utils.getValueTooltip(utils, positionPredicate.comp_1804()).build("ali.property.value.z"));
    }

    @NotNull
    public static IKeyTooltipNode getLightPredicateTooltip(IServerUtils utils, class_4552 lightPredicate) {
        return utils.getValueTooltip(utils, lightPredicate.comp_1791());
    }

    @NotNull
    public static IKeyTooltipNode getBlockPredicateTooltip(IServerUtils utils, class_4550 blockPredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, blockPredicate.comp_1731()).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, blockPredicate.comp_1732()).build("ali.property.branch.blocks")).add(utils.getValueTooltip(utils, blockPredicate.comp_1733()).build("ali.property.branch.properties")).add(utils.getValueTooltip(utils, blockPredicate.comp_1734()).build("ali.property.value.nbt"));
    }

    @NotNull
    public static IKeyTooltipNode getNbtPredicateTooltip(IServerUtils utils, class_2105 nbtPredicate) {
        return utils.getValueTooltip(utils, nbtPredicate.comp_1816());
    }

    @NotNull
    public static IKeyTooltipNode getFluidPredicateTooltip(IServerUtils utils, class_4551 fluidPredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, fluidPredicate.comp_1780()).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, fluidPredicate.comp_1781()).build("ali.property.value.fluid")).add(utils.getValueTooltip(utils, fluidPredicate.comp_1782()).build("ali.property.branch.properties"));
    }

    @NotNull
    public static IKeyTooltipNode getMobEffectPredicateTooltip(IServerUtils utils, class_2102 mobEffectsPredicate) {
        return GenericTooltipUtils.getMapTooltip(utils, mobEffectsPredicate.comp_1811(), GenericTooltipUtils::getMobEffectPredicateEntryTooltip);
    }

    @NotNull
    public static IKeyTooltipNode getEntityFlagsPredicateTooltip(IServerUtils utils, class_2040 predicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, predicate.comp_1756()).build("ali.property.value.is_on_fire")).add(utils.getValueTooltip(utils, predicate.comp_1760()).build("ali.property.value.is_baby")).add(utils.getValueTooltip(utils, predicate.comp_1757()).build("ali.property.value.is_crouching")).add(utils.getValueTooltip(utils, predicate.comp_1758()).build("ali.property.value.is_sprinting")).add(utils.getValueTooltip(utils, predicate.comp_1759()).build("ali.property.value.is_swimming"));
    }

    @NotNull
    public static IKeyTooltipNode getEntityEquipmentPredicateTooltip(IServerUtils utils, class_3735 predicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, predicate.comp_1750()).build("ali.property.branch.head")).add(utils.getValueTooltip(utils, predicate.comp_1751()).build("ali.property.branch.chest")).add(utils.getValueTooltip(utils, predicate.comp_1752()).build("ali.property.branch.legs")).add(utils.getValueTooltip(utils, predicate.comp_1753()).build("ali.property.branch.feet")).add(utils.getValueTooltip(utils, predicate.comp_1754()).build("ali.property.branch.mainhand")).add(utils.getValueTooltip(utils, predicate.comp_1755()).build("ali.property.branch.offhand"));
    }

    @NotNull
    public static IKeyTooltipNode getItemPredicateTooltip(IServerUtils utils, class_2073 itemPredicate) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, itemPredicate.comp_1783()).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, itemPredicate.comp_1784()).build("ali.property.branch.items")).add(utils.getValueTooltip(utils, itemPredicate.comp_1785()).build("ali.property.value.count")).add(utils.getValueTooltip(utils, itemPredicate.comp_1786()).build("ali.property.value.durability")).add(utils.getValueTooltip(utils, itemPredicate.comp_1787()).build("ali.property.branch.enchantments")).add(utils.getValueTooltip(utils, itemPredicate.comp_1788()).build("ali.property.branch.stored_enchantments")).add(utils.getValueTooltip(utils, itemPredicate.comp_1789()).build("ali.property.value.potion")).add(utils.getValueTooltip(utils, itemPredicate.comp_1790()).build("ali.property.value.nbt"));
    }

    @NotNull
    public static IKeyTooltipNode getEnchantmentPredicateTooltip(IServerUtils utils, class_2035 enchantmentPredicate) {
        return utils.getValueTooltip(utils, enchantmentPredicate.comp_1748().isPresent() ? enchantmentPredicate.comp_1748() : class_2561.method_43471((String)"ali.util.advanced_loot_info.any")).add(utils.getValueTooltip(utils, enchantmentPredicate.comp_1749()).build("ali.property.value.level"));
    }

    @NotNull
    public static IKeyTooltipNode getEntitySubPredicateTooltip(IServerUtils utils, class_7376 entitySubPredicate) {
        Optional<Map.Entry> optional = class_7376.class_7378.field_38731.entrySet().stream().filter(p -> p.getValue() == entitySubPredicate.comp_1776()).findFirst();
        return optional.map(entry -> {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            if (entitySubPredicate instanceof class_6404) {
                class_6404 boltPredicate = (class_6404)entitySubPredicate;
                tooltip.add(utils.getValueTooltip(utils, boltPredicate.comp_1792()).build("ali.property.value.blocks_on_fire"));
                tooltip.add(utils.getValueTooltip(utils, boltPredicate.comp_1793()).build("ali.property.branch.stuck_entity"));
            } else if (entitySubPredicate instanceof class_4965) {
                class_4965 fishingHookPredicate = (class_4965)entitySubPredicate;
                tooltip.add(utils.getValueTooltip(utils, fishingHookPredicate.comp_1779()).build("ali.property.value.in_open_water"));
            } else if (entitySubPredicate instanceof class_4553) {
                class_4553 playerPredicate = (class_4553)entitySubPredicate;
                tooltip.add(utils.getValueTooltip(utils, playerPredicate.comp_1817()).build("ali.property.value.level"));
                tooltip.add(utils.getValueTooltip(utils, playerPredicate.comp_1818()).build("ali.property.value.game_type"));
                tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, playerPredicate.comp_1819(), GenericTooltipUtils::getStatMatcherTooltip).build("ali.property.branch.stats"));
                tooltip.add(GenericTooltipUtils.getMapTooltip(utils, playerPredicate.comp_1820(), GenericTooltipUtils::getRecipeEntryTooltip).build("ali.property.branch.recipes"));
                tooltip.add(GenericTooltipUtils.getMapTooltip(utils, playerPredicate.comp_1821(), GenericTooltipUtils::getAdvancementEntryTooltip).build("ali.property.branch.advancements"));
                tooltip.add(utils.getValueTooltip(utils, playerPredicate.comp_1822()).build("ali.property.branch.looking_at"));
            } else if (entitySubPredicate instanceof class_7383) {
                class_7383 slimePredicate = (class_7383)entitySubPredicate;
                tooltip.add(utils.getValueTooltip(utils, slimePredicate.comp_1829()).build("ali.property.value.size"));
            } else {
                class_7376.field_45747.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entitySubPredicate).result().ifPresent(element -> {
                    JsonObject jsonObject = element.getAsJsonObject();
                    if (jsonObject.has("variant")) {
                        tooltip.add(utils.getValueTooltip(utils, jsonObject.getAsJsonPrimitive("variant").getAsString()).build("ali.property.value.variant"));
                    } else {
                        tooltip.add(utils.getValueTooltip(utils, jsonObject.toString()).build("ali.property.value.variant"));
                    }
                });
            }
            return tooltip;
        }).orElse(EmptyTooltipNode.empty());
    }

    @NotNull
    public static IKeyTooltipNode getBlockPosTooltip(IServerUtils ignoredUtils, class_2338 pos) {
        return ValueTooltipNode.value(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @NotNull
    public static IKeyTooltipNode getCopyOperationTooltip(IServerUtils utils, class_3837.class_3839 copyOperation) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, copyOperation.comp_1853().comp_1856()).build("ali.property.value.source")).add(utils.getValueTooltip(utils, copyOperation.comp_1854().comp_1856()).build("ali.property.value.target")).add(utils.getValueTooltip(utils, copyOperation.comp_1855()).build("ali.property.value.merge_strategy"));
    }

    @NotNull
    public static IKeyTooltipNode getEffectEntryTooltip(IServerUtils utils, class_152.class_8754 entry) {
        return utils.getValueTooltip(utils, entry.comp_1865()).add(utils.getValueTooltip(utils, entry.comp_1866()).build("ali.property.value.duration"));
    }

    @NotNull
    public static IKeyTooltipNode getCompoundTagTooltip(IServerUtils utils, class_2487 tag) {
        return utils.getValueTooltip(utils, tag.toString());
    }

    @NotNull
    public static IKeyTooltipNode getAdvancementPredicateTooltip(IServerUtils utils, class_4553.class_4556 predicate) {
        if (predicate instanceof class_4553.class_4555) {
            class_4553.class_4555 donePredicate = (class_4553.class_4555)predicate;
            return utils.getValueTooltip(utils, donePredicate.comp_1824());
        }
        if (predicate instanceof class_4553.class_4554) {
            class_4553.class_4554 criterionsPredicate = (class_4553.class_4554)predicate;
            return GenericTooltipUtils.getMapTooltip(utils, criterionsPredicate.comp_1823(), GenericTooltipUtils::getCriterionEntryTooltip);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getItemStackTooltip(IServerUtils utils, class_1799 item) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, item.method_7909()).build("ali.property.value.item")).add(utils.getValueTooltip(utils, item.method_7947()).build("ali.property.value.count")).add(utils.getValueTooltip(utils, item.method_7969()).build("ali.property.value.tag"));
    }

    @NotNull
    public static IKeyTooltipNode getNumberProviderTooltip(IServerUtils utils, class_5658 value) {
        return ValueTooltipNode.value(utils.convertNumber(utils, value));
    }

    @NotNull
    public static IKeyTooltipNode getIntRangeTooltip(IServerUtils utils, class_42 range) {
        return ValueTooltipNode.value(RangeValue.rangeToString(utils.convertNumber(utils, range.field_921), utils.convertNumber(utils, range.field_920)));
    }

    @NotNull
    public static IKeyTooltipNode getBooleanTooltip(IServerUtils ignoredUtils, Boolean value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getIntegerTooltip(IServerUtils ignoredUtils, int value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getLongTooltip(IServerUtils ignoredUtils, Long value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getByteTooltip(IServerUtils ignoredUtils, Byte value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getStringTooltip(IServerUtils ignoredUtils, String value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getFloatTooltip(IServerUtils ignoredUtils, Float value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getDoubleTooltip(IServerUtils ignoredUtils, Double value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getEnumTooltip(IServerUtils ignoredUtils, Enum<?> value) {
        return ValueTooltipNode.value(value.name());
    }

    @NotNull
    public static IKeyTooltipNode getResourceLocationTooltip(IServerUtils ignoredUtils, class_2960 value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static <T> IKeyTooltipNode getBuiltInRegistryTooltip(IServerUtils utils, class_2378<T> registry, T value) {
        return utils.getValueTooltip(utils, registry.method_10221(value));
    }

    @NotNull
    public static <T> IKeyTooltipNode getResourceKeyTooltip(IServerUtils utils, class_5321<T> value) {
        return utils.getValueTooltip(utils, value.method_29177());
    }

    @NotNull
    public static IKeyTooltipNode getTagKeyTooltip(IServerUtils utils, class_6862<?> value) {
        return utils.getValueTooltip(utils, value.comp_327());
    }

    @NotNull
    public static IKeyTooltipNode getComponentTooltip(IServerUtils ignoredUtils, class_2561 component) {
        return ComponentTooltipNode.values(new class_2561[]{component.method_27661()});
    }

    @NotNull
    public static IKeyTooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, class_2096.class_2100 ints) {
        if (ints != class_2096.class_2100.field_9708) {
            return ValueTooltipNode.value(GenericTooltipUtils.toString(ints));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, class_2096.class_2099 doubles) {
        if (doubles != class_2096.class_2099.field_9705) {
            return ValueTooltipNode.value(GenericTooltipUtils.toString(doubles));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getHolderTooltip(IServerUtils utils, class_6880<T> holder) {
        return utils.getValueTooltip(utils, holder.comp_349());
    }

    public static <T> IKeyTooltipNode getHolderSetTooltip(IServerUtils utils, class_6885<T> holderSet) {
        Either either = holderSet.method_40248();
        Optional left = either.left();
        Optional right = either.right();
        if (!left.isPresent() && right.orElse(List.of()).isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        left.ifPresent(tagKey -> tooltip.add(utils.getValueTooltip(utils, tagKey).build("ali.property.value.tag")));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                list.forEach(holder -> tooltip.add(utils.getValueTooltip(utils, holder).build("ali.property.value.null")));
            }
        });
        return tooltip;
    }

    @NotNull
    public static <T> IKeyTooltipNode getOptionalTooltip(IServerUtils utils, Optional<T> optional) {
        return optional.map(v -> utils.getValueTooltip(utils, v)).orElse(EmptyTooltipNode.empty());
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build("ali.property.value.null"));
        }
        return tooltip;
    }
}

