/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.Rect;
import com.yanny.ali.mixin.MixinVegetationBlock;
import com.yanny.ali.pip.BlockRenderState;
import com.yanny.ali.platform.Services;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public class JeiBlockSlotWidget
implements ISlottedRecipeWidget {
    private final BlockState blockState;
    private final Block block;
    private final boolean isPlant;
    private final ScreenPosition position;
    private final Rect rect;
    private final ClientLevel level;
    private final IRecipeSlotDrawable slotDrawable;

    public JeiBlockSlotWidget(IRecipeSlotDrawable slotDrawable, Block block, int x, int y) {
        this.slotDrawable = slotDrawable;
        this.block = block;
        this.blockState = block.defaultBlockState();
        this.isPlant = block instanceof VegetationBlock;
        this.position = new ScreenPosition(x, y);
        this.rect = new Rect(x, y, 24, 24);
        this.level = Minecraft.getInstance().level;
    }

    @NotNull
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double v, double v1) {
        return Optional.empty();
    }

    @NotNull
    public ScreenPosition getPosition() {
        return this.position;
    }

    public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        this.slotDrawable.draw(guiGraphics);
        if (this.block.asItem() == Items.AIR) {
            poseStack.translate((float)this.rect.x(), (float)this.rect.y());
            if (this.isPlant) {
                MixinVegetationBlock bushBlock;
                int x = (int)guiGraphics.pose().m20() - 7;
                int y = (int)guiGraphics.pose().m21() - 8;
                BlockRenderState renderState = BlockRenderState.of(this.blockState, (Level)this.level, x, y, this.rect.width() + x, this.rect.height() + y, 0.75f, null);
                BlockState farmland = Blocks.FARMLAND.defaultBlockState();
                Block block = this.block;
                BlockState base = block instanceof MixinVegetationBlock && (bushBlock = (MixinVegetationBlock)block).invokeMayPlaceOn(farmland, (BlockGetter)this.level, BlockPos.ZERO) ? farmland : Blocks.GRASS_BLOCK.defaultBlockState();
                BlockRenderState farmlandState = BlockRenderState.of(base, (Level)this.level, x + 3, y + 7, this.rect.width() + x + 3, this.rect.height() + y + 7, 0.75f, null);
                Services.getPlatform().renderBlockInGui(guiGraphics, farmlandState);
                Services.getPlatform().renderBlockInGui(guiGraphics, renderState);
            } else {
                int x = (int)guiGraphics.pose().m20() - 4;
                int y = (int)guiGraphics.pose().m21() - 4;
                BlockRenderState renderState = BlockRenderState.of(this.blockState, (Level)this.level, x, y, this.rect.width() + x, this.rect.height() + y, 1.0f, null);
                Services.getPlatform().renderBlockInGui(guiGraphics, renderState);
            }
        }
        poseStack.popMatrix();
    }

    public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
        if (this.slotDrawable.isMouseOver(mouseX, mouseY)) {
            tooltip.add((FormattedText)this.block.getName());
        }
    }
}

