/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.widget.trades.TradeWidget;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JeiTradeLoot
extends JeiBaseLoot<TradeLootType, ResourceLocation> {
    public JeiTradeLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<TradeLootType>> recipeType, LootCategory<ResourceLocation> lootCategory, Component title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(RecipeHolder<TradeLootType> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        String key = recipe.type().id().equals("empty") ? "entity.minecraft.wandering_trader" : "entity.minecraft.villager." + recipe.type().id();
        String id = recipe.type().id().equals("empty") ? "wandering_trader" : recipe.type().id();
        Component text = GenericUtils.ellipsis(key, id, 162);
        MutableComponent fullText = Component.m_264568_((String)key, (String)id);
        Rect rect = new Rect(0, 0, 162, 8);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, text, 0, 0, 0, false);
        if (rect.contains((int)mouseX, (int)mouseY)) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)fullText, (int)mouseX, (int)mouseY);
        }
    }

    @Override
    int getYOffset(TradeLootType recipe) {
        return 10;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new TradeWidget(utils, entry, rect, maxWidth);
    }
}

