/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.trades;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.ItemStackNode;
import com.yanny.ali.plugin.common.nodes.TagNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemsToItemsNode
extends ListNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "items_to_items");
    private final List<ITooltipNode> tooltip;

    public ItemsToItemsNode(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> input1, RangeValue input1Count, Either<ItemStack, TagKey<? extends ItemLike>> output, RangeValue outputCount, int maxUses, int xp, float priceMultiplier, List<ITooltipNode> conditions) {
        this(utils, input1, input1Count, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)ItemStack.f_41583_), new RangeValue(), output, outputCount, maxUses, xp, priceMultiplier, conditions);
    }

    public ItemsToItemsNode(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> input1, RangeValue input1Count, Either<ItemStack, TagKey<? extends ItemLike>> input2, RangeValue input2Count, Either<ItemStack, TagKey<? extends ItemLike>> output, RangeValue outputCount, int maxUses, int xp, float priceMultiplier, List<ITooltipNode> conditions) {
        this(utils, input1, input1Count, Collections.emptyList(), input2, input2Count, Collections.emptyList(), output, outputCount, Collections.emptyList(), maxUses, xp, priceMultiplier, conditions);
    }

    public ItemsToItemsNode(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> input1, RangeValue input1Count, List<ITooltipNode> input1Conditions, Either<ItemStack, TagKey<? extends ItemLike>> input2, RangeValue input2Count, List<ITooltipNode> input2Conditions, Either<ItemStack, TagKey<? extends ItemLike>> output, RangeValue outputCount, List<ITooltipNode> outputConditions, int maxUses, int xp, float priceMultiplier, List<ITooltipNode> conditions) {
        this.addChildren(ItemsToItemsNode.getChildren(utils, input1, input1Count, input1Conditions));
        this.addChildren(ItemsToItemsNode.getChildren(utils, input2, input2Count, input2Conditions));
        this.addChildren(ItemsToItemsNode.getChildren(utils, output, outputCount, outputConditions));
        this.tooltip = new ArrayList<ITooltipNode>(conditions);
        this.tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.uses", maxUses));
        this.tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.villager_xp", xp));
        this.tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.price_multiplier", Float.valueOf(priceMultiplier)));
    }

    public ItemsToItemsNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
    }

    private static IDataNode getChildren(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> item, RangeValue count, List<ITooltipNode> conditions) {
        return (IDataNode)item.map(i -> new ItemStackNode(utils, (ItemStack)i, count, conditions), t -> new TagNode(utils, (TagKey<? extends ItemLike>)t, count, conditions));
    }
}

