/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.jetbrains.annotations.NotNull;

public class EntitySubPredicateTooltipUtils {
    @NotNull
    public static ITooltipNode getLightningBoltPredicateTooltip(IServerUtils utils, LightningBoltPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.lightning_bolt", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.blocks_on_fire", predicate.f_290996_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.stuck_entity", predicate.f_290675_(), GenericTooltipUtils::getEntityPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getFishingHookPredicateTooltip(IServerUtils utils, FishingHookPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.fishing_hook", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.in_open_water", predicate.f_39757_(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPlayerPredicateTooltip(IServerUtils utils, PlayerPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.player", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", predicate.f_62245_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.game_type", predicate.f_62246_(), GenericTooltipUtils::getEnumTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.stats", predicate.f_62247_(), GenericTooltipUtils::getStatMatcherTooltip));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.recipes", predicate.f_62248_(), GenericTooltipUtils::getRecipeEntryTooltip));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.advancements", predicate.f_62249_(), GenericTooltipUtils::getAdvancementEntryTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.looking_at", predicate.f_156744_(), GenericTooltipUtils::getEntityPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSlimePredicateTooltip(IServerUtils utils, SlimePredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.slime", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.size", predicate.f_223418_()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getRaiderPredicateTooltip(IServerUtils utils, RaiderPredicate predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.raider", new Object[0]));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_raid", predicate.f_315999_()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.is_captain", predicate.f_315971_()));
        return tooltip;
    }

    @NotNull
    public static <V> ITooltipNode getVariantPredicateTooltip(IServerUtils utils, EntitySubPredicates.EntityVariantPredicateType.Instance predicate) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getEntitySubPredicateTooltip(utils, "ali.property.value.type", (EntitySubPredicate)predicate);
        Object object = predicate.f_316369_;
        if (object instanceof Enum) {
            Enum variant = (Enum)object;
            tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.variant", variant));
        }
        return tooltip;
    }

    @NotNull
    public static <V> ITooltipNode getHolderVariantPredicateTooltip(IServerUtils utils, EntitySubPredicates.EntityHolderVariantPredicateType.Instance predicate) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getEntitySubPredicateTooltip(utils, "ali.property.value.type", (EntitySubPredicate)predicate);
        tooltip.add(GenericTooltipUtils.getHolderSetTooltip(utils, "ali.property.branch.variants", "ali.property.value.variant", predicate.f_314024_, (u, s, v) -> {
            Object object = v;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CatVariant.class, PaintingVariant.class, FrogVariant.class, WolfVariant.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    CatVariant catVariant = (CatVariant)selector0$temp;
                    yield RegistriesTooltipUtils.getCatVariantTooltip(u, s, catVariant);
                }
                case 1 -> {
                    PaintingVariant paintingVariant = (PaintingVariant)selector0$temp;
                    yield RegistriesTooltipUtils.getPaintingVariantTooltip(u, s, paintingVariant);
                }
                case 2 -> {
                    FrogVariant frogVariant = (FrogVariant)selector0$temp;
                    yield RegistriesTooltipUtils.getFrogVariantTooltip(u, s, frogVariant);
                }
                case 3 -> {
                    WolfVariant wolfVariant = (WolfVariant)selector0$temp;
                    yield RegistriesTooltipUtils.getWolfVariantTooltip(u, s, wolfVariant);
                }
                default -> new TooltipNode();
            };
        }));
        return tooltip;
    }
}

