/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.yanny.ali.api.ICommonUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.manager.ClassKeyedMap;
import com.yanny.ali.manager.FunctionStatsTracker;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import com.yanny.ali.plugin.common.trades.TradeUtils;
import com.yanny.ali.plugin.server.ConditionTooltipUtils;
import com.yanny.ali.plugin.server.FunctionTooltipUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.IngredientTooltipUtils;
import com.yanny.ali.plugin.server.ValueTooltipUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public class AliServerRegistry
implements IServerRegistry,
IServerUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Class<?>, BiFunction<IServerUtils, LootPoolEntryContainer, List<Item>>> entryItemCollectorMap = new HashMap();
    private final Map<Class<?>, TriFunction<IServerUtils, List<Item>, LootItemFunction, List<Item>>> functionItemCollectorMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, NumberProvider, RangeValue>> numberConverterMap = new HashMap();
    private final Map<Class<?>, IServerRegistry.EntryFactory<?>> entryFactoryMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, LootItemFunction, ITooltipNode>> functionTooltipMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, LootItemCondition, ITooltipNode>> conditionTooltipMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, Ingredient, ITooltipNode>> ingredientTooltipMap = new HashMap();
    private final ClassKeyedMap<BiFunction<IServerUtils, Object, IKeyTooltipNode>> valueTooltipMap = new ClassKeyedMap();
    private final Map<Class<?>, BiFunction<IServerUtils, ItemSubPredicate, ITooltipNode>> itemSubPredicateTooltipMap = new HashMap();
    private final Map<MapCodec<?>, BiFunction<IServerUtils, EntitySubPredicate, ITooltipNode>> entitySubPredicateTooltipMap = new HashMap();
    private final Map<DataComponentType<?>, BiFunction<IServerUtils, Object, ITooltipNode>> dataComponentTypeTooltipMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, ConsumeEffect, ITooltipNode>> consumeEffectTooltipMap = new HashMap();
    private final Map<Class<?>, TriConsumer<IServerUtils, LootItemCondition, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>> chanceModifierMap = new HashMap();
    private final Map<Class<?>, TriConsumer<IServerUtils, LootItemFunction, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>> countModifierMap = new HashMap();
    private final Map<Class<?>, TriFunction<IServerUtils, LootItemFunction, ItemStack, ItemStack>> itemStackModifierMap = new HashMap();
    private final Map<ResourceLocation, LootTable> lootTableMap = new HashMap<ResourceLocation, LootTable>();
    private final List<Function<IServerUtils, List<ILootModifier<?>>>> lootModifierGetters = new LinkedList();
    private final List<ILootModifier<?>> lootModifierMap = new LinkedList();
    private final Map<Class<?>, TriFunction<IServerUtils, VillagerTrades.ItemListing, ITooltipNode, IDataNode>> itemListingFactoryMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, VillagerTrades.ItemListing, Pair<List<Item>, List<Item>>>> tradeItemCollectorMap = new HashMap();
    private final Set<Class<?>> missingEntryFactories = new HashSet();
    private final Set<Class<?>> missingFunctionTooltips = new HashSet();
    private final Set<Class<?>> missingConditionTooltips = new HashSet();
    private final Set<Class<?>> missingIngredientTooltips = new HashSet();
    private final Set<Class<?>> missingValueTooltips = new HashSet();
    private final Set<Class<?>> missingItemSubPredicateTooltips = new HashSet();
    private final Set<Class<?>> missingEntitySubPredicateTooltips = new HashSet();
    private final Set<Class<?>> missingDataComponentTypeTooltips = new HashSet();
    private final Set<Class<?>> missingConsumeEffectTooltips = new HashSet();
    private final Set<Class<?>> missingItemListingFactories = new HashSet();
    private final Set<Class<?>> missingNumberConverters = new HashSet();
    private final FunctionStatsTracker entryTracker = new FunctionStatsTracker(IServerRegistry.EntryFactory.class);
    private final FunctionStatsTracker functionTracker = new FunctionStatsTracker(FunctionTooltipUtils.class);
    private final FunctionStatsTracker conditionTracker = new FunctionStatsTracker(ConditionTooltipUtils.class);
    private final FunctionStatsTracker ingredientTracker = new FunctionStatsTracker(IngredientTooltipUtils.class);
    private final ICommonUtils utils;
    private ServerLevel serverLevel;
    private LootContext lootContext;

    public AliServerRegistry(ICommonUtils utils) {
        this.utils = utils;
    }

    public void clearData() {
        this.entryItemCollectorMap.clear();
        this.functionItemCollectorMap.clear();
        this.numberConverterMap.clear();
        this.entryFactoryMap.clear();
        this.functionTooltipMap.clear();
        this.conditionTooltipMap.clear();
        this.ingredientTooltipMap.clear();
        this.itemSubPredicateTooltipMap.clear();
        this.entitySubPredicateTooltipMap.clear();
        this.dataComponentTypeTooltipMap.clear();
        this.consumeEffectTooltipMap.clear();
        this.chanceModifierMap.clear();
        this.countModifierMap.clear();
        this.itemStackModifierMap.clear();
        this.lootTableMap.clear();
        this.lootModifierGetters.clear();
        this.lootModifierMap.clear();
        this.itemListingFactoryMap.clear();
        this.tradeItemCollectorMap.clear();
        this.missingEntryFactories.clear();
        this.missingFunctionTooltips.clear();
        this.missingConditionTooltips.clear();
        this.missingIngredientTooltips.clear();
        this.missingItemSubPredicateTooltips.clear();
        this.missingEntitySubPredicateTooltips.clear();
        this.missingDataComponentTypeTooltips.clear();
        this.missingConsumeEffectTooltips.clear();
        this.missingItemListingFactories.clear();
        this.missingNumberConverters.clear();
        this.entryTracker.clearStats();
        this.functionTracker.clearStats();
        this.conditionTracker.clearStats();
        this.ingredientTracker.clearStats();
    }

    public void addLootTable(ResourceLocation resourceLocation, LootTable lootTable) {
        this.lootTableMap.put(resourceLocation, lootTable);
    }

    public void clearLootTables() {
        this.lootTableMap.clear();
    }

    public void prepareLootModifiers() {
        for (Function<IServerUtils, List<ILootModifier<?>>> lootModifierGetter : this.lootModifierGetters) {
            this.lootModifierMap.addAll((Collection)lootModifierGetter.apply(this));
        }
    }

    public List<ILootModifier<?>> getLootModifiers() {
        return this.lootModifierMap;
    }

    public void setServerLevel(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
        this.lootContext = new LootContext(new LootParams(serverLevel, null, Map.of(), 0.0f), RandomSource.create(), null);
    }

    @Override
    public <T extends LootPoolEntryContainer> void registerItemCollector(Class<T> type, BiFunction<IServerUtils, T, List<Item>> itemSupplier) {
        this.entryItemCollectorMap.put(type, (u, e) -> (List)itemSupplier.apply((IServerUtils)u, (Object)e));
    }

    @Override
    public <T extends LootItemFunction> void registerItemCollector(Class<T> type, TriFunction<IServerUtils, List<Item>, T, List<Item>> itemSupplier) {
        this.functionItemCollectorMap.put(type, (TriFunction<IServerUtils, List<Item>, LootItemFunction, List<Item>>)((TriFunction)(u, l, f) -> (List)itemSupplier.apply(u, l, f)));
    }

    @Override
    public <T extends LootPoolEntryContainer> void registerEntry(Class<T> type, IServerRegistry.EntryFactory<T> entryFactory) {
        this.entryFactoryMap.put(type, entryFactory);
    }

    @Override
    public <T extends LootItemFunction> void registerFunctionTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.functionTooltipMap.put(type, (u, f) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)f));
    }

    @Override
    public <T extends LootItemCondition> void registerConditionTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.conditionTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends Ingredient> void registerIngredientTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.ingredientTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T> void registerValueTooltip(Class<T> type, BiFunction<IServerUtils, T, IKeyTooltipNode> getter) {
        this.valueTooltipMap.put(type, (u, v) -> (IKeyTooltipNode)getter.apply((IServerUtils)u, (Object)v));
    }

    @Override
    public <T extends ItemSubPredicate> void registerItemSubPredicateTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.itemSubPredicateTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends EntitySubPredicate> void registerEntitySubPredicateTooltip(MapCodec<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.entitySubPredicateTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T> void registerDataComponentTypeTooltip(DataComponentType<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.dataComponentTypeTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends ConsumeEffect> void registerConsumeEffectTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.consumeEffectTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends NumberProvider> void registerNumberProvider(Class<T> type, BiFunction<IServerUtils, T, RangeValue> converter) {
        this.numberConverterMap.put(type, (u, t) -> (RangeValue)converter.apply((IServerUtils)u, (Object)t));
    }

    @Override
    public <T extends LootItemFunction> void registerCountModifier(Class<T> type, TriConsumer<IServerUtils, T, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> consumer) {
        this.countModifierMap.put(type, (TriConsumer<IServerUtils, LootItemFunction, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends LootItemCondition> void registerChanceModifier(Class<T> type, TriConsumer<IServerUtils, T, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> consumer) {
        this.chanceModifierMap.put(type, (TriConsumer<IServerUtils, LootItemCondition, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends LootItemFunction> void registerItemStackModifier(Class<T> type, TriFunction<IServerUtils, T, ItemStack, ItemStack> consumer) {
        this.itemStackModifierMap.put(type, (TriFunction<IServerUtils, LootItemFunction, ItemStack, ItemStack>)((TriFunction)(u, f, i) -> (ItemStack)consumer.apply(u, f, i)));
    }

    @Override
    public void registerLootModifiers(Function<IServerUtils, List<ILootModifier<?>>> getter) {
        this.lootModifierGetters.add(getter);
    }

    @Override
    public <T extends VillagerTrades.ItemListing> void registerItemListing(Class<T> type, TriFunction<IServerUtils, T, ITooltipNode, IDataNode> tradeFactory) {
        this.itemListingFactoryMap.put(type, (TriFunction<IServerUtils, VillagerTrades.ItemListing, ITooltipNode, IDataNode>)((TriFunction)(u, i, c) -> (IDataNode)tradeFactory.apply(u, i, c)));
    }

    @Override
    public <T extends VillagerTrades.ItemListing> void registerItemListingCollector(Class<T> type, BiFunction<IServerUtils, T, Pair<List<Item>, List<Item>>> itemSupplier) {
        this.tradeItemCollectorMap.put(type, (u, i) -> (Pair)itemSupplier.apply((IServerUtils)u, (Object)i));
    }

    @Override
    public <T extends LootPoolEntryContainer> List<Item> collectItems(IServerUtils utils, T entry) {
        BiFunction<IServerUtils, LootPoolEntryContainer, List<Item>> itemSupplier = this.entryItemCollectorMap.get(entry.getClass());
        if (itemSupplier != null) {
            return itemSupplier.apply(utils, entry);
        }
        return List.of();
    }

    @Override
    public <T extends LootItemFunction> List<Item> collectItems(IServerUtils utils, List<Item> items, T function) {
        TriFunction<IServerUtils, List<Item>, LootItemFunction, List<Item>> itemSupplier = this.functionItemCollectorMap.get(function.getClass());
        if (itemSupplier != null) {
            return (List)itemSupplier.apply((Object)utils, items, function);
        }
        return List.of();
    }

    @Override
    public <T extends LootPoolEntryContainer> IServerRegistry.EntryFactory<T> getEntryFactory(IServerUtils utils, T type) {
        IServerRegistry.EntryFactory<?> entryFactory = this.entryFactoryMap.get(type.getClass());
        if (entryFactory != null) {
            this.entryTracker.incrementCallCount(type.getClass());
            return entryFactory;
        }
        this.missingEntryFactories.add(type.getClass());
        return (utils1, entry, chance, sumWeight, functions, conditions) -> new MissingNode();
    }

    @Override
    public <T extends LootItemFunction> ITooltipNode getFunctionTooltip(IServerUtils utils, T function) {
        BiFunction<IServerUtils, LootItemFunction, ITooltipNode> entryTooltipGetter = this.functionTooltipMap.get(function.getClass());
        if (entryTooltipGetter != null) {
            this.functionTracker.incrementCallCount(function.getClass());
            return entryTooltipGetter.apply(utils, function);
        }
        this.missingFunctionTooltips.add(function.getClass());
        try {
            return GenericTooltipUtils.getMissingFunction(utils, function);
        }
        catch (Throwable e) {
            LOGGER.warn("Function type {} was not registered", (Object)function.getClass().getCanonicalName());
            return ValueTooltipUtils.getStringTooltip(utils, function.getClass().getSimpleName()).build("ali.util.advanced_loot_info.missing");
        }
    }

    @Override
    public <T extends LootItemCondition> ITooltipNode getConditionTooltip(IServerUtils utils, T condition) {
        BiFunction<IServerUtils, LootItemCondition, ITooltipNode> entryTooltipGetter = this.conditionTooltipMap.get(condition.getClass());
        if (entryTooltipGetter != null) {
            this.conditionTracker.incrementCallCount(condition.getClass());
            return entryTooltipGetter.apply(utils, condition);
        }
        this.missingConditionTooltips.add(condition.getClass());
        try {
            return GenericTooltipUtils.getMissingCondition(utils, condition);
        }
        catch (Throwable e) {
            LOGGER.warn("Condition type for {} was not registered", (Object)condition.getClass().getCanonicalName());
            return ValueTooltipUtils.getStringTooltip(utils, condition.getClass().getSimpleName()).build("ali.util.advanced_loot_info.missing");
        }
    }

    @Override
    public <T extends Ingredient> ITooltipNode getIngredientTooltip(IServerUtils utils, T ingredient) {
        BiFunction<IServerUtils, Ingredient, ITooltipNode> ingredientTooltipGetter = this.ingredientTooltipMap.get(ingredient.getClass());
        if (ingredientTooltipGetter != null) {
            this.ingredientTracker.incrementCallCount(ingredient.getClass());
            return ingredientTooltipGetter.apply(utils, ingredient);
        }
        this.missingIngredientTooltips.add(ingredient.getClass());
        return ErrorTooltipNode.error("[" + ingredient.getClass().getName() + "]").build();
    }

    @Override
    public <T> IKeyTooltipNode getValueTooltip(IServerUtils utils, @Nullable T value) {
        if (value == null) {
            return EmptyTooltipNode.empty();
        }
        BiFunction<IServerUtils, Object, IKeyTooltipNode> valueTooltipGetter = this.valueTooltipMap.get(value.getClass());
        if (valueTooltipGetter != null) {
            return valueTooltipGetter.apply(utils, value);
        }
        this.missingValueTooltips.add(value.getClass());
        return ErrorTooltipNode.error("[" + value.getClass().getName() + "]");
    }

    @Override
    public <T extends ItemSubPredicate> ITooltipNode getItemSubPredicateTooltip(IServerUtils utils, T predicate) {
        BiFunction<IServerUtils, ItemSubPredicate, ITooltipNode> itemSubPredicateTooltipGetter = this.itemSubPredicateTooltipMap.get(predicate.getClass());
        if (itemSubPredicateTooltipGetter != null) {
            return itemSubPredicateTooltipGetter.apply(utils, predicate);
        }
        this.missingItemSubPredicateTooltips.add(predicate.getClass());
        return utils.getValueTooltip(utils, predicate.getClass().getSimpleName()).build("ali.util.advanced_loot_info.missing");
    }

    @Override
    public <T extends EntitySubPredicate> ITooltipNode getEntitySubPredicateTooltip(IServerUtils utils, T predicate) {
        BiFunction<IServerUtils, EntitySubPredicate, ITooltipNode> entitySubPredicateTooltipGetter = this.entitySubPredicateTooltipMap.get(predicate.codec());
        if (entitySubPredicateTooltipGetter != null) {
            return entitySubPredicateTooltipGetter.apply(utils, predicate);
        }
        this.missingEntitySubPredicateTooltips.add(predicate.getClass());
        return utils.getValueTooltip(utils, predicate.getClass().getSimpleName()).build("ali.util.advanced_loot_info.missing");
    }

    @Override
    public ITooltipNode getDataComponentTypeTooltip(IServerUtils utils, DataComponentType<?> type, Object value) {
        BiFunction<IServerUtils, Object, ITooltipNode> dataComponentTypeTooltipGetter = this.dataComponentTypeTooltipMap.get(type);
        if (dataComponentTypeTooltipGetter != null) {
            return dataComponentTypeTooltipGetter.apply(utils, value);
        }
        this.missingDataComponentTypeTooltips.add(type.getClass());
        return utils.getValueTooltip(utils, type.getClass().getSimpleName()).build("ali.util.advanced_loot_info.missing");
    }

    @Override
    public <T extends ConsumeEffect> ITooltipNode getConsumeEffectTooltip(IServerUtils utils, T effect) {
        BiFunction<IServerUtils, ConsumeEffect, ITooltipNode> consumeEffectTooltipGetter = this.consumeEffectTooltipMap.get(effect.getClass());
        if (consumeEffectTooltipGetter != null) {
            return consumeEffectTooltipGetter.apply(utils, effect);
        }
        this.missingConsumeEffectTooltips.add(effect.getClass());
        return utils.getValueTooltip(utils, effect.getClass().getSimpleName()).build("ali.util.advanced_loot_info.missing");
    }

    @Override
    public <T extends LootItemFunction> void applyCountModifier(IServerUtils utils, T function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        TriConsumer<IServerUtils, LootItemFunction, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> bonusCountConsumer = this.countModifierMap.get(function.getClass());
        if (bonusCountConsumer != null) {
            bonusCountConsumer.accept((Object)utils, function, count);
        }
    }

    @Override
    public <T extends LootItemCondition> void applyChanceModifier(IServerUtils utils, T condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        TriConsumer<IServerUtils, LootItemCondition, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> bonusChanceConsumer = this.chanceModifierMap.get(condition.getClass());
        if (bonusChanceConsumer != null) {
            bonusChanceConsumer.accept((Object)utils, condition, chance);
        }
    }

    @Override
    public <T extends LootItemFunction> ItemStack applyItemStackModifier(IServerUtils utils, T function, ItemStack itemStack) {
        TriFunction<IServerUtils, LootItemFunction, ItemStack, ItemStack> bonusChanceConsumer = this.itemStackModifierMap.get(function.getClass());
        if (bonusChanceConsumer != null) {
            itemStack = (ItemStack)bonusChanceConsumer.apply((Object)utils, function, (Object)itemStack);
        }
        return itemStack;
    }

    @Override
    public <T extends VillagerTrades.ItemListing> IDataNode getItemListing(IServerUtils utils, T entry, ITooltipNode condition) {
        TriFunction<IServerUtils, VillagerTrades.ItemListing, ITooltipNode, IDataNode> itemListingFactory = this.itemListingFactoryMap.get(entry.getClass());
        if (itemListingFactory != null) {
            return (IDataNode)itemListingFactory.apply((Object)utils, entry, (Object)condition);
        }
        try {
            MerchantOffer offer = entry.getOffer(null, null);
            if (offer != null) {
                return TradeUtils.getNode(utils, offer, condition);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.missingItemListingFactories.add(entry.getClass());
        return new MissingNode();
    }

    @Override
    public <T extends VillagerTrades.ItemListing> Pair<List<Item>, List<Item>> collectItems(IServerUtils utils, T entry) {
        BiFunction<IServerUtils, VillagerTrades.ItemListing, Pair<List<Item>, List<Item>>> itemCollector = this.tradeItemCollectorMap.get(entry.getClass());
        if (itemCollector != null) {
            return itemCollector.apply(utils, entry);
        }
        try {
            MerchantOffer offer = entry.getOffer(null, null);
            if (offer != null) {
                return TradeUtils.collectItems(utils, offer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Pair(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public RangeValue convertNumber(IServerUtils utils, @Nullable NumberProvider numberProvider) {
        if (numberProvider != null) {
            BiFunction<IServerUtils, NumberProvider, RangeValue> function = this.numberConverterMap.get(numberProvider.getClass());
            if (function != null) {
                try {
                    return function.apply(utils, numberProvider);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Failed to convert number with error {}", (Object)throwable.getMessage());
                }
            } else {
                this.missingNumberConverters.add(numberProvider.getClass());
            }
        }
        return new RangeValue(false, true);
    }

    @Override
    @Nullable
    public ServerLevel getServerLevel() {
        return this.serverLevel;
    }

    @Override
    @Nullable
    public LootContext getLootContext() {
        return this.lootContext;
    }

    @Override
    @Nullable
    public LootTable getLootTable(Either<ResourceLocation, LootTable> either) {
        return (LootTable)either.map(this.lootTableMap::get, lootTable -> lootTable);
    }

    @Override
    @Nullable
    public HolderLookup.Provider lookupProvider() {
        return this.serverLevel != null ? this.serverLevel.registryAccess() : null;
    }

    public IDataNode parseTable(List<ILootModifier<?>> modifiers, LootTable lootTable) {
        return new LootTableNode(modifiers, this, lootTable);
    }

    public IDataNode parseTable(List<ILootModifier<?>> modifiers) {
        return new LootTableNode(modifiers, this);
    }

    public IDataNode parseTrade(Int2ObjectMap<VillagerTrades.ItemListing[]> itemListingMap) {
        return new TradeNode(this, itemListingMap);
    }

    @Override
    public List<Entity> createEntities(EntityType<?> type, Level level) {
        return this.utils.createEntities(type, level);
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} entry item collectors", (Object)this.entryItemCollectorMap.size());
        LOGGER.info("Registered {} function item collectors", (Object)this.functionItemCollectorMap.size());
        LOGGER.info("Registered {} number converters", (Object)this.numberConverterMap.size());
        LOGGER.info("Registered {} entry factories", (Object)this.entryFactoryMap.size());
        LOGGER.info("Registered {} function tooltips", (Object)this.functionTooltipMap.size());
        LOGGER.info("Registered {} condition tooltips", (Object)this.conditionTooltipMap.size());
        LOGGER.info("Registered {} ingredient tooltips", (Object)this.ingredientTooltipMap.size());
        LOGGER.info("Registered {} item sub predicate tooltips", (Object)this.itemSubPredicateTooltipMap.size());
        LOGGER.info("Registered {} entity sub predicate tooltips", (Object)this.entitySubPredicateTooltipMap.size());
        LOGGER.info("Registered {} data component type tooltips", (Object)this.dataComponentTypeTooltipMap.size());
        LOGGER.info("Registered {} chance modifiers", (Object)this.chanceModifierMap.size());
        LOGGER.info("Registered {} count modifiers", (Object)this.countModifierMap.size());
        LOGGER.info("Registered {} item stack modifiers", (Object)this.itemStackModifierMap.size());
        LOGGER.info("Registered {} loot modifiers", (Object)this.lootModifierMap.size());
        LOGGER.info("Registered {} item listing factories", (Object)this.itemListingFactoryMap.size());
    }

    public void printRuntimeInfo() {
        this.missingEntryFactories.forEach(t -> LOGGER.warn("Missing entry factory for {}", (Object)t.getName()));
        this.missingFunctionTooltips.forEach(t -> LOGGER.warn("Missing function tooltip for {}", (Object)t.getName()));
        this.missingConditionTooltips.forEach(t -> LOGGER.warn("Missing condition tooltip for {}", (Object)t.getName()));
        this.missingIngredientTooltips.forEach(t -> LOGGER.warn("Missing ingredient tooltip for {}", (Object)t.getName()));
        this.missingValueTooltips.forEach(t -> LOGGER.warn("Missing value tooltip for {}", (Object)t.getName()));
        this.missingItemSubPredicateTooltips.forEach(t -> LOGGER.warn("Missing item sub predicate tooltip for {}", (Object)t.getName()));
        this.missingEntitySubPredicateTooltips.forEach(t -> LOGGER.warn("Missing entity sub predicate tooltip for {}", (Object)t.getName()));
        this.missingDataComponentTypeTooltips.forEach(t -> LOGGER.warn("Missing data component type tooltip for {}", (Object)t.getName()));
        this.missingConsumeEffectTooltips.forEach(t -> LOGGER.warn("Missing consume effect tooltip for {}", (Object)t.getName()));
        this.missingItemListingFactories.forEach(t -> LOGGER.warn("Missing trade item listing for {}", (Object)t.getName()));
        this.missingNumberConverters.forEach(t -> LOGGER.warn("Missing number converters for {}", (Object)t.getName()));
        this.entryTracker.logStats();
        this.functionTracker.logStats();
        this.conditionTracker.logStats();
        this.ingredientTracker.logStats();
    }
}

