/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ITooltipNode {
    public static final ChatFormatting TEXT_STYLE = ChatFormatting.GOLD;
    public static final ChatFormatting PARAM_STYLE = ChatFormatting.AQUA;

    public static void encodeNode(IServerUtils utils, ITooltipNode node, RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(node.getId());
        node.encode(utils, buf);
    }

    public static ITooltipNode decodeNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        ResourceLocation name = buf.readResourceLocation();
        IClientRegistry.TooltipFactory factory = utils.getTooltipNodeFactory(name);
        if (factory != null) {
            return factory.create(utils, buf);
        }
        throw new IllegalStateException("No factory defined for tooltip node " + String.valueOf(name));
    }

    @NotNull
    public static Component pair(Object value1, Object value2) {
        return Component.translatable((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{ITooltipNode.convertObject(value1), ITooltipNode.convertObject(value2)});
    }

    @NotNull
    public static Component pad(int count, Object arg) {
        if (count > 0) {
            return ITooltipNode.pair(Component.translatable((String)("ali.util.advanced_loot_info.pad." + count)), ITooltipNode.convertObject(arg));
        }
        return ITooltipNode.convertObject(arg);
    }

    @NotNull
    public static MutableComponent convertObject(@Nullable Object object) {
        if (object instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)object;
            return component;
        }
        if (object != null) {
            return Component.literal((String)object.toString());
        }
        return Component.literal((String)"null");
    }

    public List<Component> getComponents(int var1, boolean var2);

    public void encode(IServerUtils var1, RegistryFriendlyByteBuf var2);

    public ResourceLocation getId();
}

