/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.trades;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.trades.TradeLevelNode;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class TradeNode
extends ListNode {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"ali", (String)"trade");

    public TradeNode(IServerUtils utils, Int2ObjectMap<VillagerTrades.ItemListing[]> itemListingMap) {
        List<Int2ObjectMap.Entry> entries = itemListingMap.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).toList();
        for (Int2ObjectMap.Entry entry : entries) {
            if (((VillagerTrades.ItemListing[])entry.getValue()).length <= 0) continue;
            this.addChildren(new TradeLevelNode(utils, entry.getIntKey(), (VillagerTrades.ItemListing[])entry.getValue()));
        }
    }

    public TradeNode(IServerUtils utils, List<Pair<VillagerTrades.ItemListing[], Integer>> itemListingList) {
        this(utils, TradeNode.convert(itemListingList));
    }

    public TradeNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
    }

    @Override
    public ITooltipNode getTooltip() {
        return EmptyTooltipNode.EMPTY;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    private static Int2ObjectMap<VillagerTrades.ItemListing[]> convert(List<Pair<VillagerTrades.ItemListing[], Integer>> itemListingList) {
        List<Pair> list = itemListingList.stream().sorted(Comparator.comparing(Pair::getRight)).toList();
        Int2ObjectArrayMap itemListingMap = new Int2ObjectArrayMap();
        for (Pair pair : list) {
            itemListingMap.compute((Object)((Integer)pair.getRight()), (i, listing) -> {
                if (listing == null) {
                    return (VillagerTrades.ItemListing[])pair.getLeft();
                }
                return (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])listing, (Object[])((VillagerTrades.ItemListing[])pair.getLeft()));
            });
        }
        return itemListingMap;
    }
}

