/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.platform;

import com.mojang.logging.LogUtils;
import com.yanny.ali.AliMod;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.manager.PluginHolder;
import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.platform.services.IPlatformHelper;
import java.util.LinkedList;
import java.util.List;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public List<PluginHolder> getPlugins() {
        LinkedList<PluginHolder> plugins = new LinkedList<PluginHolder>();
        Type type = Type.getType(AliEntrypoint.class);
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotationData : scanData.getAnnotations()) {
                if (!type.equals((Object)annotationData.annotationType())) continue;
                try {
                    Class<?> clazz = Class.forName(annotationData.memberName());
                    if (IPlugin.class.isAssignableFrom(clazz)) {
                        Class<IPlugin> pluginClass = clazz.asSubclass(IPlugin.class);
                        IPlugin plugin = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        String modId = ((IModInfo)((IModFileInfo)scanData.getIModInfoData().get(0)).getMods().get(0)).getModId();
                        plugins.add(new PluginHolder(modId, plugin));
                        continue;
                    }
                    LOGGER.warn("{} doesn't implement {}", (Object)annotationData.memberName(), (Object)IPlugin.class.getName());
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to load plugin with error: {}", (Object)t.getMessage());
                }
            }
        }
        LOGGER.info("Found {} plugin(s", (Object)plugins.size());
        return plugins;
    }

    @Override
    public DistHolder<AbstractClient, AbstractServer> getInfoPropagator() {
        return AliMod.INFO_PROPAGATOR;
    }
}

