/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.plugin.client.GenericTooltipUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.jetbrains.annotations.NotNull;

public class EntitySubPredicateTooltipUtils {
    @NotNull
    public static List<Component> getLightningBoltPredicateTooltip(IClientUtils utils, int pad, LightningBoltPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.lightning_bolt", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.blocks_on_fire", predicate.blocksSetOnFire()));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.stuck_entity", predicate.entityStruck(), GenericTooltipUtils::getEntityPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getFishingHookPredicateTooltip(IClientUtils utils, int pad, FishingHookPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.fishing_hook", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.in_open_water", predicate.inOpenWater(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getPlayerPredicateTooltip(IClientUtils utils, int pad, PlayerPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.player", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.level", predicate.level()));
        components.addAll(GenericTooltipUtils.getGameTypeTooltip(utils, pad + 1, predicate.gameType()));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.stats", predicate.stats(), GenericTooltipUtils::getStatMatcherTooltip));
        components.addAll(GenericTooltipUtils.getRecipesTooltip(utils, pad + 1, (Object2BooleanMap<ResourceLocation>)predicate.recipes()));
        components.addAll(GenericTooltipUtils.getAdvancementsTooltip(utils, pad + 1, predicate.advancements()));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.looking_at", predicate.lookingAt(), GenericTooltipUtils::getEntityPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSlimePredicateTooltip(IClientUtils utils, int pad, SlimePredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.slime", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.size", predicate.size()));
        return components;
    }

    @NotNull
    public static List<Component> getRaiderPredicateTooltip(IClientUtils utils, int pad, RaiderPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.raider", new Object[0])));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.has_raid", predicate.hasRaid()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.is_captain", predicate.isCaptain()));
        return components;
    }

    @NotNull
    public static <V> List<Component> getVariantPredicateTooltip(IClientUtils utils, int pad, EntitySubPredicates.EntityVariantPredicateType.Instance predicate) {
        LinkedList<Component> components = new LinkedList<Component>(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.type", Objects.requireNonNull(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE.getKey((Object)predicate.codec()))));
        Object object = predicate.variant;
        if (object instanceof Enum) {
            Enum variant = (Enum)object;
            components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.variant", variant));
        }
        return components;
    }

    @NotNull
    public static <V> List<Component> getHolderVariantPredicateTooltip(IClientUtils utils, int pad, EntitySubPredicates.EntityHolderVariantPredicateType.Instance predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.type", Objects.requireNonNull(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE.getKey((Object)predicate.codec()))));
        components.addAll(GenericTooltipUtils.getHolderSetTooltip(utils, pad + 1, "ali.property.branch.variants", predicate.variants, (u, i, v) -> {
            if (v instanceof CatVariant) {
                CatVariant catVariant = (CatVariant)v;
                return GenericTooltipUtils.getResourceLocationTooltip(u, i, "ali.property.value.variant", Objects.requireNonNull(BuiltInRegistries.CAT_VARIANT.getKey((Object)catVariant)));
            }
            if (v instanceof PaintingVariant) {
                Optional<Holder.Reference> first;
                Optional lookup;
                PaintingVariant paintingVariant = (PaintingVariant)v;
                HolderLookup.Provider provider = utils.lookupProvider();
                if (provider != null && (lookup = provider.lookup(Registries.PAINTING_VARIANT)).isPresent() && (first = ((HolderLookup.RegistryLookup)lookup.get()).listElements().filter(l -> l.value() == paintingVariant).findFirst()).isPresent()) {
                    return GenericTooltipUtils.getResourceKeyTooltip(u, i, "ali.property.value.variant", Objects.requireNonNull(first.get().key()));
                }
            } else {
                if (v instanceof FrogVariant) {
                    FrogVariant frogVariant = (FrogVariant)v;
                    return GenericTooltipUtils.getResourceLocationTooltip(u, i, "ali.property.value.variant", Objects.requireNonNull(BuiltInRegistries.FROG_VARIANT.getKey((Object)frogVariant)));
                }
                if (v instanceof WolfVariant) {
                    Optional<Holder.Reference> first;
                    Optional lookup;
                    WolfVariant wolfVariant = (WolfVariant)v;
                    HolderLookup.Provider provider = utils.lookupProvider();
                    if (provider != null && (lookup = provider.lookup(Registries.WOLF_VARIANT)).isPresent() && (first = ((HolderLookup.RegistryLookup)lookup.get()).listElements().filter(l -> l.value() == wolfVariant).findFirst()).isPresent()) {
                        return GenericTooltipUtils.getResourceKeyTooltip(u, i, "ali.property.value.variant", Objects.requireNonNull(first.get().key()));
                    }
                }
            }
            return List.of();
        }));
        return components;
    }
}

