/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.plugin.client.TooltipUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class ItemWidget
implements IEntryWidget {
    private final Rect bounds;
    private final LootPoolEntryContainer entry;

    public ItemWidget(IWidgetUtils utils, LootPoolEntryContainer entry, int x, int y, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        LootItem itemEntry = (LootItem)entry;
        LinkedList<LootItemFunction> allFunctions = new LinkedList<LootItemFunction>(functions);
        LinkedList<LootItemCondition> allConditions = new LinkedList<LootItemCondition>(conditions);
        allFunctions.addAll(itemEntry.functions);
        allConditions.addAll(itemEntry.conditions);
        float rawChance = (float)itemEntry.weight / (float)sumWeight;
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance = TooltipUtils.getChance(utils, allConditions, rawChance);
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> count = TooltipUtils.getCount(utils, allFunctions);
        this.bounds = utils.addSlotWidget((Item)itemEntry.item.value(), (LootPoolEntryContainer)itemEntry, x, y, chance, count, allFunctions, allConditions);
        this.entry = entry;
    }

    @Override
    public Rect getRect() {
        return this.bounds;
    }

    @Override
    public LootPoolEntryContainer getLootEntry() {
        return this.entry;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    @NotNull
    public static Rect getBounds(IClientUtils utils, LootPoolEntryContainer entry, int x, int y) {
        return new Rect(x, y, 18, 18);
    }
}

