/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.plugin.client.WidgetUtils;
import com.yanny.ali.plugin.client.widget.LootPoolWidget;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class LootTableWidget
implements IWidget {
    private final List<IWidget> widgets;
    private final Rect bounds;

    public LootTableWidget(IWidgetUtils utils, LootTable lootTable, int x, int y) {
        this(utils, lootTable, x, y, 0, 100.0f, List.of(), List.of());
    }

    public LootTableWidget(IWidgetUtils utils, LootTable lootTable, int x, int y, int quality, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        int posX = x + 7;
        int posY = y;
        int width = 0;
        int height = 0;
        LinkedList<LootItemFunction> allFunctions = new LinkedList<LootItemFunction>(functions);
        allFunctions.addAll(lootTable.functions);
        this.widgets = new LinkedList<IWidget>();
        this.widgets.add(WidgetUtils.getLootTableTypeWidget(x, y, quality, chance));
        for (LootPool pool : lootTable.pools) {
            LootPoolWidget widget = new LootPoolWidget(utils, pool, posX, posY, List.copyOf(allFunctions), List.copyOf(conditions));
            Rect bound = widget.getRect();
            width = Math.max(width, bound.width());
            height += bound.height() + 2;
            posY += bound.height() + 2;
            this.widgets.add(widget);
        }
        this.bounds = new Rect(x, y, width + 7, height);
    }

    @Override
    public Rect getRect() {
        return this.bounds;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int lastY = 0;
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
            lastY = widget.getRect().y();
        }
        int top = this.bounds.y() + 18;
        int height = lastY - this.bounds.y() - 9;
        WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 3, top, 2, height, 0, 0, 2, 18);
        for (IWidget widget : this.widgets) {
            if (widget.getRect().y() <= this.bounds.y() + 18) continue;
            WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 4, widget.getRect().y() + 8, 3, 2, 2, 0, 18, 2);
        }
    }

    @Override
    public List<Component> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<Component> components = new LinkedList<Component>();
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }

    @NotNull
    public static Rect getBounds(IClientUtils utils, LootTable lootTable, int x, int y) {
        int posX = x + 7;
        int posY = y;
        int width = 0;
        int height = 0;
        for (LootPool pool : lootTable.pools) {
            Rect bound = LootPoolWidget.getBounds(utils, pool, posX, posY);
            width = Math.max(width, bound.width());
            height += bound.height() + 2;
            posY += bound.height() + 2;
        }
        if (height == 0) {
            height = 18;
        }
        return new Rect(x, y, width + 7, height);
    }
}

