/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiBlockCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.compatibility.rei.ReiEntityCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.compatibility.rei.ReiGameplayCategory;
import com.yanny.ali.compatibility.rei.ReiGameplayDisplay;
import com.yanny.ali.compatibility.rei.ReiTradeCategory;
import com.yanny.ali.compatibility.rei.ReiTradeDisplay;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ReiCompatibility
implements REIClientPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Holder<ReiBlockDisplay, BlockLootType, class_2248>> blockCategoryList = new LinkedList<Holder<ReiBlockDisplay, BlockLootType, class_2248>>();
    private final List<Holder<ReiEntityDisplay, EntityLootType, class_1299<?>>> entityCategoryList = new LinkedList();
    private final List<Holder<ReiGameplayDisplay, GameplayLootType, String>> gameplayCategoryList = new LinkedList<Holder<ReiGameplayDisplay, GameplayLootType, String>>();
    private final List<Holder<ReiTradeDisplay, TradeLootType, String>> tradeCategoryList = new LinkedList<Holder<ReiTradeDisplay, TradeLootType, String>>();

    public void registerCategories(CategoryRegistry registry) {
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.tradeCategoryList.clear();
        this.blockCategoryList.add(this.createCategory(LootCategories.PLANT_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiBlockDisplay::new, ReiBlockCategory::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(this.createCategory(LootCategories.BLOCK_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiEntityDisplay::new, ReiEntityCategory::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(this.createCategory(LootCategories.ENTITY_LOOT, ReiEntityDisplay::new, ReiEntityCategory::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiGameplayDisplay::new, ReiGameplayCategory::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(this.createCategory(LootCategories.GAMEPLAY_LOOT, ReiGameplayDisplay::new, ReiGameplayCategory::new));
        this.tradeCategoryList.addAll(LootCategories.TRADE_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiTradeDisplay::new, ReiTradeCategory::new)).collect(Collectors.toSet()));
        this.tradeCategoryList.add(this.createCategory(LootCategories.TRADE_LOOT, ReiTradeDisplay::new, ReiTradeCategory::new));
        for (Holder<ReiBlockDisplay, BlockLootType, class_2248> holder : this.blockCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.entityCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.gameplayCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.tradeCategoryList) {
            registry.add(holder.category);
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        CompletableFuture futureData = new CompletableFuture();
        PluginManager.CLIENT_REGISTRY.setOnDoneListener((lootData, tradeData) -> futureData.complete(Pair.of((Object)lootData, (Object)tradeData)));
        if (!futureData.isDone()) {
            LOGGER.info("Blocking this thread until all data are received!");
        }
        try {
            Pair pair = (Pair)futureData.get(30L, TimeUnit.SECONDS);
            this.registerData(registry, (Map)pair.getLeft(), (Map)pair.getRight());
        }
        catch (TimeoutException e) {
            futureData.cancel(true);
            PluginManager.CLIENT_REGISTRY.clearLootData();
            LOGGER.error("Failed to received data in 30 seconds, registration aborted!");
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.error("Failed to finish registering data with error {}", (Object)e.getMessage());
        }
    }

    private void registerData(DisplayRegistry registry, Map<class_2960, IDataNode> lootData, Map<class_2960, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        class_638 level = class_310.method_1551().field_1687;
        LOGGER.info("Adding loot information to REI");
        if (level != null) {
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap gameplayRecipeTypes = new HashMap();
            HashMap tradeRecipeTypes = new HashMap();
            GenericUtils.processData(level, clientRegistry, lootData, tradeData, (node, location, block, outputs) -> {
                for (Holder<ReiBlockDisplay, BlockLootType, class_2248> holder : this.blockCategoryList) {
                    if (!holder.category.getLootCategory().validate(block)) continue;
                    blockRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new BlockLootType((class_2248)block, (IDataNode)node, Collections.emptyList(), (List<class_1799>)outputs));
                    break;
                }
            }, (node, location, entity, outputs) -> {
                for (Holder<ReiEntityDisplay, EntityLootType, class_1299<?>> holder : this.entityCategoryList) {
                    if (!holder.category.getLootCategory().validate(entity)) continue;
                    entityRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new EntityLootType((class_1299<?>)entity, (class_2960)location, (IDataNode)node, Collections.emptyList(), (List<class_1799>)outputs));
                    break;
                }
            }, (node, location, outputs) -> {
                for (Holder<ReiGameplayDisplay, GameplayLootType, String> holder : this.gameplayCategoryList) {
                    if (!holder.category.getLootCategory().validate(location.method_12832())) continue;
                    gameplayRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new GameplayLootType((IDataNode)node, location.method_12832(), Collections.emptyList(), (List<class_1799>)outputs));
                    break;
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                for (Holder<ReiTradeDisplay, TradeLootType, String> holder : this.tradeCategoryList) {
                    if (!holder.category.getLootCategory().validate(location.method_12832())) continue;
                    tradeRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.method_12832(), (List<class_1799>)inputs, (List<class_1799>)outputs));
                    break;
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                for (Holder<ReiTradeDisplay, TradeLootType, String> holder : this.tradeCategoryList) {
                    if (!holder.category.getLootCategory().validate(location.method_12832())) continue;
                    tradeRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.method_12832(), (List<class_1799>)inputs, (List<class_1799>)outputs));
                    break;
                }
            });
            for (Map.Entry entry : blockRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.blockPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : entityRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.entityPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : gameplayRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.gameplayPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : tradeRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.tradePredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
        } else {
            LOGGER.warn("REI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(Map.Entry<class_2960, LootCategory<U>> e, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, class_2561, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        class_2960 id = e.getKey();
        CategoryIdentifier identifier = CategoryIdentifier.of((String)id.method_12836(), (String)id.method_12832());
        class_5250 title = class_2561.method_43471((String)("emi.category." + id.method_12836() + "." + id.method_12832().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, e.getValue()), filler);
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(LootCategory<U> lootCategory, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, class_2561, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        CategoryIdentifier identifier = CategoryIdentifier.of((String)"ali", (String)lootCategory.getKey());
        class_5250 title = class_2561.method_43471((String)("emi.category.ali." + lootCategory.getKey().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, lootCategory), filler);
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> blockPredicate(List<BlockLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof BlockLootType) {
                BlockLootType type = (BlockLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> entityPredicate(List<EntityLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof EntityLootType) {
                EntityLootType type = (EntityLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> gameplayPredicate(List<GameplayLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof GameplayLootType) {
                GameplayLootType type = (GameplayLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> tradePredicate(List<TradeLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof TradeLootType) {
                TradeLootType type = (TradeLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    private record Holder<D extends ReiBaseDisplay, T, U>(CategoryIdentifier<D> identifier, ReiBaseCategory<D, U> category, BiFunction<T, DisplayAdditionReasons, D> filler) {
    }
}

