/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ICommonUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.manager.IOnDoneListener;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class AliClientRegistry
implements IClientRegistry,
IClientUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PADDING = 2;
    private final Map<class_2960, IClientRegistry.IWidgetFactory> widgetMap = new HashMap<class_2960, IClientRegistry.IWidgetFactory>();
    private final Map<class_2960, IClientRegistry.NodeFactory<?>> nodeFactoryMap = new HashMap();
    private final Map<class_2960, List<class_1799>> lootItemMap = new HashMap<class_2960, List<class_1799>>();
    private final Map<class_2960, IDataNode> lootNodeMap = new HashMap<class_2960, IDataNode>();
    private final Map<class_2960, IDataNode> lootTradeMap = new HashMap<class_2960, IDataNode>();
    private final Map<class_2960, List<class_1792>> tradeInputItemMap = new HashMap<class_2960, List<class_1792>>();
    private final Map<class_2960, List<class_1792>> tradeOutputItemMap = new HashMap<class_2960, List<class_1792>>();
    private final ICommonUtils utils;
    private IOnDoneListener listener = null;
    private volatile boolean dataReceived = false;

    public AliClientRegistry(ICommonUtils utils) {
        this.utils = utils;
    }

    public void addLootData(class_2960 resourceLocation, IDataNode node, List<class_1799> items) {
        this.lootItemMap.put(resourceLocation, items);
        this.lootNodeMap.put(resourceLocation, node);
    }

    public void addTradeData(class_2960 resourceLocation, IDataNode node, List<class_1792> inputs, List<class_1792> outputs) {
        this.lootTradeMap.put(resourceLocation, node);
        this.tradeInputItemMap.put(resourceLocation, inputs);
        this.tradeOutputItemMap.put(resourceLocation, outputs);
    }

    public synchronized void startLootData() {
        this.dataReceived = false;
        this.lootNodeMap.clear();
        this.lootTradeMap.clear();
        this.lootItemMap.clear();
        LOGGER.info("Started receiving loot data");
    }

    public synchronized void clearLootData() {
        this.listener = null;
        this.dataReceived = false;
        this.lootNodeMap.clear();
        this.lootTradeMap.clear();
        this.lootItemMap.clear();
        LOGGER.info("Cleared Loot data");
    }

    public synchronized void doneLootData() {
        this.dataReceived = true;
        LOGGER.info("Finished receiving loot data");
        if (this.listener != null) {
            LOGGER.info("Received data {}/{}", (Object)this.lootNodeMap.size(), (Object)this.lootTradeMap.size());
            this.listener.onDone(this.lootNodeMap, this.lootTradeMap);
            this.listener = null;
            this.dataReceived = false;
        }
    }

    public synchronized void setOnDoneListener(IOnDoneListener listener) {
        if (this.dataReceived) {
            LOGGER.info("Already done receiving data {}/{}", (Object)this.lootNodeMap.size(), (Object)this.lootTradeMap.size());
            listener.onDone(this.lootNodeMap, this.lootTradeMap);
            this.dataReceived = false;
        } else {
            LOGGER.info("Registered done listener");
            this.listener = listener;
        }
    }

    @Override
    public void registerWidget(class_2960 id, IClientRegistry.IWidgetFactory factory) {
        this.widgetMap.put(id, factory);
    }

    @Override
    public <T extends IDataNode> void registerNode(class_2960 id, IClientRegistry.NodeFactory<T> nodeFactory) {
        this.nodeFactoryMap.put(id, nodeFactory);
    }

    @Override
    public List<IWidget> createWidgets(IWidgetUtils utils, List<IDataNode> entries, RelativeRect parent, int maxWidth) {
        int posX = 0;
        int posY = 0;
        LinkedList<IWidget> widgets = new LinkedList<IWidget>();
        WidgetDirection lastDirection = null;
        for (IDataNode entry : entries) {
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.getOrDefault(entry.getId(), this.widgetMap.get(MissingNode.ID));
            IWidget widget = widgetFactory.create(utils, entry, new RelativeRect(posX, posY, parent.width - posX, 0, parent), maxWidth);
            RelativeRect bounds = widget.getRect();
            WidgetDirection direction = widget.getDirection();
            if (lastDirection == null) {
                if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bounds.width;
                } else {
                    posY += bounds.height + 2;
                }
            } else if (lastDirection == WidgetDirection.HORIZONTAL && direction == WidgetDirection.HORIZONTAL) {
                if (bounds.getRight() <= maxWidth) {
                    posX += bounds.width;
                } else {
                    posX = bounds.width;
                    bounds.setOffset(0, posY += ((IWidget)widgets.get((int)(widgets.size() - 1))).getRect().height);
                }
            } else {
                posX = 0;
                if (direction != lastDirection) {
                    if (lastDirection == WidgetDirection.HORIZONTAL) {
                        posY += ((IWidget)widgets.get((int)(widgets.size() - 1))).getRect().height + 2;
                    }
                    bounds.setOffset(posX, posY);
                }
                posY += bounds.height + 2;
            }
            widgets.add(widget);
            lastDirection = direction;
        }
        int w = 0;
        int h = 0;
        for (IWidget widget : widgets) {
            RelativeRect rect = widget.getRect();
            w = Math.max(w, rect.offsetX + rect.width);
            h = Math.max(h, rect.offsetY + rect.height);
        }
        parent.setDimensions(w, h);
        return widgets;
    }

    @Override
    public <T extends IDataNode> IClientRegistry.NodeFactory<T> getNodeFactory(class_2960 id) {
        IClientRegistry.NodeFactory<?> nodeFactory = this.nodeFactoryMap.get(id);
        return Objects.requireNonNullElseGet(nodeFactory, () -> {
            throw new IllegalStateException(String.format("Failed to construct node - node {%s} was not registered!", id));
        });
    }

    @Override
    public List<class_1799> getLootItems(class_2960 location) {
        return this.lootItemMap.getOrDefault(location, Collections.emptyList());
    }

    @Override
    public List<class_1792> getTradeInputItems(class_2960 location) {
        return this.tradeInputItemMap.getOrDefault(location, Collections.emptyList());
    }

    @Override
    public List<class_1792> getTradeOutputItems(class_2960 location) {
        return this.tradeOutputItemMap.getOrDefault(location, Collections.emptyList());
    }

    @Override
    public List<class_1297> createEntities(class_1299<?> type, class_1937 level) {
        return this.utils.createEntities(type, level);
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} widgets", (Object)this.widgetMap.size());
        LOGGER.info("Registered {} node factories", (Object)this.nodeFactoryMap.size());
        LOGGER.info("Registered {} trade factories", (Object)this.lootTradeMap.size());
    }
}

