/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.yanny.ali.api.ICommonUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.manager.FunctionStatsTracker;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import com.yanny.ali.plugin.common.trades.TradeUtils;
import com.yanny.ali.plugin.server.ConditionTooltipUtils;
import com.yanny.ali.plugin.server.FunctionTooltipUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.IngredientTooltipUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_117;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7376;
import net.minecraft.class_79;
import net.minecraft.class_8567;
import net.minecraft.class_9331;
import net.minecraft.class_9360;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public class AliServerRegistry
implements IServerRegistry,
IServerUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Class<?>, BiFunction<IServerUtils, class_79, List<class_1792>>> entryItemCollectorMap = new HashMap();
    private final Map<Class<?>, TriFunction<IServerUtils, List<class_1792>, class_117, List<class_1792>>> functionItemCollectorMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, class_5658, RangeValue>> numberConverterMap = new HashMap();
    private final Map<Class<?>, IServerRegistry.EntryFactory<?>> entryFactoryMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, class_117, ITooltipNode>> functionTooltipMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, class_5341, ITooltipNode>> conditionTooltipMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, class_1856, ITooltipNode>> ingredientTooltipMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, class_9360, ITooltipNode>> itemSubPredicateTooltipMap = new HashMap();
    private final Map<MapCodec<?>, BiFunction<IServerUtils, class_7376, ITooltipNode>> entitySubPredicateTooltipMap = new HashMap();
    private final Map<class_9331<?>, BiFunction<IServerUtils, Object, ITooltipNode>> dataComponentTypeTooltipMap = new HashMap();
    private final Map<Class<?>, TriConsumer<IServerUtils, class_5341, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>> chanceModifierMap = new HashMap();
    private final Map<Class<?>, TriConsumer<IServerUtils, class_117, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>> countModifierMap = new HashMap();
    private final Map<Class<?>, TriFunction<IServerUtils, class_117, class_1799, class_1799>> itemStackModifierMap = new HashMap();
    private final Map<class_2960, class_52> lootTableMap = new HashMap<class_2960, class_52>();
    private final List<Function<IServerUtils, List<ILootModifier<?>>>> lootModifierGetters = new LinkedList();
    private final List<ILootModifier<?>> lootModifierMap = new LinkedList();
    private final Map<Class<?>, TriFunction<IServerUtils, class_3853.class_1652, List<ITooltipNode>, IDataNode>> itemListingFactoryMap = new HashMap();
    private final Map<Class<?>, BiFunction<IServerUtils, class_3853.class_1652, Pair<List<class_1792>, List<class_1792>>>> tradeItemCollectorMap = new HashMap();
    private final Set<Class<?>> missingEntryFactories = new HashSet();
    private final Set<Class<?>> missingFunctionTooltips = new HashSet();
    private final Set<Class<?>> missingConditionTooltips = new HashSet();
    private final Set<Class<?>> missingIngredientTooltips = new HashSet();
    private final Set<Class<?>> missingItemSubPredicateTooltips = new HashSet();
    private final Set<Class<?>> missingEntitySubPredicateTooltips = new HashSet();
    private final Set<Class<?>> missingDataComponentTypeTooltips = new HashSet();
    private final Set<Class<?>> missingItemListingFactories = new HashSet();
    private final Set<Class<?>> missingNumberConverters = new HashSet();
    private final FunctionStatsTracker entryTracker = new FunctionStatsTracker(IServerRegistry.EntryFactory.class);
    private final FunctionStatsTracker functionTracker = new FunctionStatsTracker(FunctionTooltipUtils.class);
    private final FunctionStatsTracker conditionTracker = new FunctionStatsTracker(ConditionTooltipUtils.class);
    private final FunctionStatsTracker ingredientTracker = new FunctionStatsTracker(IngredientTooltipUtils.class);
    private final ICommonUtils utils;
    private class_3218 serverLevel;
    private class_47 lootContext;

    public AliServerRegistry(ICommonUtils utils) {
        this.utils = utils;
    }

    public void clearData() {
        this.entryItemCollectorMap.clear();
        this.functionItemCollectorMap.clear();
        this.numberConverterMap.clear();
        this.entryFactoryMap.clear();
        this.functionTooltipMap.clear();
        this.conditionTooltipMap.clear();
        this.ingredientTooltipMap.clear();
        this.itemSubPredicateTooltipMap.clear();
        this.entitySubPredicateTooltipMap.clear();
        this.dataComponentTypeTooltipMap.clear();
        this.chanceModifierMap.clear();
        this.countModifierMap.clear();
        this.itemStackModifierMap.clear();
        this.lootTableMap.clear();
        this.lootModifierGetters.clear();
        this.lootModifierMap.clear();
        this.itemListingFactoryMap.clear();
        this.tradeItemCollectorMap.clear();
        this.missingEntryFactories.clear();
        this.missingFunctionTooltips.clear();
        this.missingConditionTooltips.clear();
        this.missingIngredientTooltips.clear();
        this.missingItemSubPredicateTooltips.clear();
        this.missingEntitySubPredicateTooltips.clear();
        this.missingDataComponentTypeTooltips.clear();
        this.missingItemListingFactories.clear();
        this.missingNumberConverters.clear();
        this.entryTracker.clearStats();
        this.functionTracker.clearStats();
        this.conditionTracker.clearStats();
        this.ingredientTracker.clearStats();
    }

    public void addLootTable(class_2960 resourceLocation, class_52 lootTable) {
        this.lootTableMap.put(resourceLocation, lootTable);
    }

    public void clearLootTables() {
        this.lootTableMap.clear();
    }

    public void prepareLootModifiers() {
        for (Function<IServerUtils, List<ILootModifier<?>>> lootModifierGetter : this.lootModifierGetters) {
            this.lootModifierMap.addAll((Collection)lootModifierGetter.apply(this));
        }
    }

    public List<ILootModifier<?>> getLootModifiers() {
        return this.lootModifierMap;
    }

    public void setServerLevel(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
        this.lootContext = new class_47(new class_8567(serverLevel, Map.of(), Map.of(), 0.0f), class_5819.method_43047(), null);
    }

    @Override
    public <T extends class_79> void registerItemCollector(Class<T> type, BiFunction<IServerUtils, T, List<class_1792>> itemSupplier) {
        this.entryItemCollectorMap.put(type, (u, e) -> (List)itemSupplier.apply((IServerUtils)u, (Object)e));
    }

    @Override
    public <T extends class_117> void registerItemCollector(Class<T> type, TriFunction<IServerUtils, List<class_1792>, T, List<class_1792>> itemSupplier) {
        this.functionItemCollectorMap.put(type, (TriFunction<IServerUtils, List<class_1792>, class_117, List<class_1792>>)((TriFunction)(u, l, f) -> (List)itemSupplier.apply(u, l, f)));
    }

    @Override
    public <T extends class_79> void registerEntry(Class<T> type, IServerRegistry.EntryFactory<T> entryFactory) {
        this.entryFactoryMap.put(type, entryFactory);
    }

    @Override
    public <T extends class_117> void registerFunctionTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.functionTooltipMap.put(type, (u, f) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)f));
    }

    @Override
    public <T extends class_5341> void registerConditionTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.conditionTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends class_1856> void registerIngredientTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.ingredientTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends class_9360> void registerItemSubPredicateTooltip(Class<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.itemSubPredicateTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends class_7376> void registerEntitySubPredicateTooltip(MapCodec<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.entitySubPredicateTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T> void registerDataComponentTypeTooltip(class_9331<T> type, BiFunction<IServerUtils, T, ITooltipNode> getter) {
        this.dataComponentTypeTooltipMap.put(type, (u, c) -> (ITooltipNode)getter.apply((IServerUtils)u, (Object)c));
    }

    @Override
    public <T extends class_5658> void registerNumberProvider(Class<T> type, BiFunction<IServerUtils, T, RangeValue> converter) {
        this.numberConverterMap.put(type, (u, t) -> (RangeValue)converter.apply((IServerUtils)u, (Object)t));
    }

    @Override
    public <T extends class_117> void registerCountModifier(Class<T> type, TriConsumer<IServerUtils, T, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> consumer) {
        this.countModifierMap.put(type, (TriConsumer<IServerUtils, class_117, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends class_5341> void registerChanceModifier(Class<T> type, TriConsumer<IServerUtils, T, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> consumer) {
        this.chanceModifierMap.put(type, (TriConsumer<IServerUtils, class_5341, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends class_117> void registerItemStackModifier(Class<T> type, TriFunction<IServerUtils, T, class_1799, class_1799> consumer) {
        this.itemStackModifierMap.put(type, (TriFunction<IServerUtils, class_117, class_1799, class_1799>)((TriFunction)(u, f, i) -> (class_1799)consumer.apply(u, f, i)));
    }

    @Override
    public void registerLootModifiers(Function<IServerUtils, List<ILootModifier<?>>> getter) {
        this.lootModifierGetters.add(getter);
    }

    @Override
    public <T extends class_3853.class_1652> void registerItemListing(Class<T> type, TriFunction<IServerUtils, T, List<ITooltipNode>, IDataNode> tradeFactory) {
        this.itemListingFactoryMap.put(type, (TriFunction<IServerUtils, class_3853.class_1652, List<ITooltipNode>, IDataNode>)((TriFunction)(u, i, c) -> (IDataNode)tradeFactory.apply(u, i, c)));
    }

    @Override
    public <T extends class_3853.class_1652> void registerItemListingCollector(Class<T> type, BiFunction<IServerUtils, T, Pair<List<class_1792>, List<class_1792>>> itemSupplier) {
        this.tradeItemCollectorMap.put(type, (u, i) -> (Pair)itemSupplier.apply((IServerUtils)u, (Object)i));
    }

    @Override
    public <T extends class_79> List<class_1792> collectItems(IServerUtils utils, T entry) {
        BiFunction<IServerUtils, class_79, List<class_1792>> itemSupplier = this.entryItemCollectorMap.get(entry.getClass());
        if (itemSupplier != null) {
            return itemSupplier.apply(utils, entry);
        }
        return List.of();
    }

    @Override
    public <T extends class_117> List<class_1792> collectItems(IServerUtils utils, List<class_1792> items, T function) {
        TriFunction<IServerUtils, List<class_1792>, class_117, List<class_1792>> itemSupplier = this.functionItemCollectorMap.get(function.getClass());
        if (itemSupplier != null) {
            return (List)itemSupplier.apply((Object)utils, items, function);
        }
        return List.of();
    }

    @Override
    public <T extends class_79> IServerRegistry.EntryFactory<T> getEntryFactory(IServerUtils utils, T type) {
        IServerRegistry.EntryFactory<?> entryFactory = this.entryFactoryMap.get(type.getClass());
        if (entryFactory != null) {
            this.entryTracker.incrementCallCount(type.getClass());
            return entryFactory;
        }
        this.missingEntryFactories.add(type.getClass());
        return (utils1, entry, chance, sumWeight, functions, conditions) -> new MissingNode();
    }

    @Override
    public <T extends class_117> ITooltipNode getFunctionTooltip(IServerUtils utils, T function) {
        BiFunction<IServerUtils, class_117, ITooltipNode> entryTooltipGetter = this.functionTooltipMap.get(function.getClass());
        if (entryTooltipGetter != null) {
            this.functionTracker.incrementCallCount(function.getClass());
            return entryTooltipGetter.apply(utils, function);
        }
        this.missingFunctionTooltips.add(function.getClass());
        try {
            return GenericTooltipUtils.getMissingFunction(utils, function);
        }
        catch (Throwable e) {
            LOGGER.warn("Function type {} was not registered", (Object)function.getClass().getCanonicalName());
            return GenericTooltipUtils.getStringTooltip(utils, "ali.util.advanced_loot_info.missing", function.getClass().getSimpleName());
        }
    }

    @Override
    public <T extends class_5341> ITooltipNode getConditionTooltip(IServerUtils utils, T condition) {
        BiFunction<IServerUtils, class_5341, ITooltipNode> entryTooltipGetter = this.conditionTooltipMap.get(condition.getClass());
        if (entryTooltipGetter != null) {
            this.conditionTracker.incrementCallCount(condition.getClass());
            return entryTooltipGetter.apply(utils, condition);
        }
        this.missingConditionTooltips.add(condition.getClass());
        try {
            return GenericTooltipUtils.getMissingCondition(utils, condition);
        }
        catch (Throwable e) {
            LOGGER.warn("Condition type for {} was not registered", (Object)condition.getClass().getCanonicalName());
            return GenericTooltipUtils.getStringTooltip(utils, "ali.util.advanced_loot_info.missing", condition.getClass().getSimpleName());
        }
    }

    @Override
    public <T extends class_1856> ITooltipNode getIngredientTooltip(IServerUtils utils, T ingredient) {
        BiFunction<IServerUtils, class_1856, ITooltipNode> ingredientTooltipGetter = this.ingredientTooltipMap.get(ingredient.getClass());
        if (ingredientTooltipGetter != null) {
            this.ingredientTracker.incrementCallCount(ingredient.getClass());
            return ingredientTooltipGetter.apply(utils, ingredient);
        }
        this.missingIngredientTooltips.add(ingredient.getClass());
        return GenericTooltipUtils.getStringTooltip(utils, "ali.util.advanced_loot_info.missing", ingredient.getClass().getSimpleName());
    }

    @Override
    public <T extends class_9360> ITooltipNode getItemSubPredicateTooltip(IServerUtils utils, T predicate) {
        BiFunction<IServerUtils, class_9360, ITooltipNode> itemSubPredicateTooltipGetter = this.itemSubPredicateTooltipMap.get(predicate.getClass());
        if (itemSubPredicateTooltipGetter != null) {
            return itemSubPredicateTooltipGetter.apply(utils, predicate);
        }
        this.missingItemSubPredicateTooltips.add(predicate.getClass());
        return GenericTooltipUtils.getStringTooltip(utils, "ali.util.advanced_loot_info.missing", predicate.getClass().getSimpleName());
    }

    @Override
    public <T extends class_7376> ITooltipNode getEntitySubPredicateTooltip(IServerUtils utils, T predicate) {
        BiFunction<IServerUtils, class_7376, ITooltipNode> entitySubPredicateTooltipGetter = this.entitySubPredicateTooltipMap.get(predicate.method_58152());
        if (entitySubPredicateTooltipGetter != null) {
            return entitySubPredicateTooltipGetter.apply(utils, predicate);
        }
        this.missingEntitySubPredicateTooltips.add(predicate.getClass());
        return GenericTooltipUtils.getStringTooltip(utils, "ali.util.advanced_loot_info.missing", predicate.getClass().getSimpleName());
    }

    @Override
    public ITooltipNode getDataComponentTypeTooltip(IServerUtils utils, class_9331<?> type, Object value) {
        BiFunction<IServerUtils, Object, ITooltipNode> dataComponentTypeTooltipGetter = this.dataComponentTypeTooltipMap.get(type);
        if (dataComponentTypeTooltipGetter != null) {
            return dataComponentTypeTooltipGetter.apply(utils, value);
        }
        this.missingDataComponentTypeTooltips.add(type.getClass());
        return GenericTooltipUtils.getStringTooltip(utils, "ali.util.advanced_loot_info.missing", type.getClass().getSimpleName());
    }

    @Override
    public <T extends class_117> void applyCountModifier(IServerUtils utils, T function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        TriConsumer<IServerUtils, class_117, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> bonusCountConsumer = this.countModifierMap.get(function.getClass());
        if (bonusCountConsumer != null) {
            bonusCountConsumer.accept((Object)utils, function, count);
        }
    }

    @Override
    public <T extends class_5341> void applyChanceModifier(IServerUtils utils, T condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        TriConsumer<IServerUtils, class_5341, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> bonusChanceConsumer = this.chanceModifierMap.get(condition.getClass());
        if (bonusChanceConsumer != null) {
            bonusChanceConsumer.accept((Object)utils, condition, chance);
        }
    }

    @Override
    public <T extends class_117> class_1799 applyItemStackModifier(IServerUtils utils, T function, class_1799 itemStack) {
        TriFunction<IServerUtils, class_117, class_1799, class_1799> bonusChanceConsumer = this.itemStackModifierMap.get(function.getClass());
        if (bonusChanceConsumer != null) {
            itemStack = (class_1799)bonusChanceConsumer.apply((Object)utils, function, (Object)itemStack);
        }
        return itemStack;
    }

    @Override
    public <T extends class_3853.class_1652> IDataNode getItemListing(IServerUtils utils, T entry, List<ITooltipNode> conditions) {
        TriFunction<IServerUtils, class_3853.class_1652, List<ITooltipNode>, IDataNode> itemListingFactory = this.itemListingFactoryMap.get(entry.getClass());
        if (itemListingFactory != null) {
            return (IDataNode)itemListingFactory.apply((Object)utils, entry, conditions);
        }
        try {
            class_1914 offer = entry.method_7246(null, null);
            if (offer != null) {
                return TradeUtils.getNode(utils, offer, conditions);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.missingItemListingFactories.add(entry.getClass());
        return new MissingNode();
    }

    @Override
    public <T extends class_3853.class_1652> Pair<List<class_1792>, List<class_1792>> collectItems(IServerUtils utils, T entry) {
        BiFunction<IServerUtils, class_3853.class_1652, Pair<List<class_1792>, List<class_1792>>> itemCollector = this.tradeItemCollectorMap.get(entry.getClass());
        if (itemCollector != null) {
            return itemCollector.apply(utils, entry);
        }
        try {
            class_1914 offer = entry.method_7246(null, null);
            if (offer != null) {
                return TradeUtils.collectItems(utils, offer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Pair(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public RangeValue convertNumber(IServerUtils utils, @Nullable class_5658 numberProvider) {
        if (numberProvider != null) {
            BiFunction<IServerUtils, class_5658, RangeValue> function = this.numberConverterMap.get(numberProvider.getClass());
            if (function != null) {
                try {
                    return function.apply(utils, numberProvider);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Failed to convert number with error {}", (Object)throwable.getMessage());
                }
            } else {
                this.missingNumberConverters.add(numberProvider.getClass());
            }
        }
        return new RangeValue(false, true);
    }

    @Override
    @Nullable
    public class_3218 getServerLevel() {
        return this.serverLevel;
    }

    @Override
    @Nullable
    public class_47 getLootContext() {
        return this.lootContext;
    }

    @Override
    @Nullable
    public class_52 getLootTable(Either<class_2960, class_52> either) {
        return (class_52)either.map(this.lootTableMap::get, lootTable -> lootTable);
    }

    @Override
    @Nullable
    public class_7225.class_7874 lookupProvider() {
        return this.serverLevel != null ? this.serverLevel.method_30349() : null;
    }

    public IDataNode parseTable(List<ILootModifier<?>> modifiers, class_52 lootTable) {
        return new LootTableNode(modifiers, this, lootTable);
    }

    public IDataNode parseTrade(Int2ObjectMap<class_3853.class_1652[]> itemListingMap) {
        return new TradeNode(this, itemListingMap);
    }

    @Override
    public List<class_1297> createEntities(class_1299<?> type, class_1937 level) {
        return this.utils.createEntities(type, level);
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} entry item collectors", (Object)this.entryItemCollectorMap.size());
        LOGGER.info("Registered {} function item collectors", (Object)this.functionItemCollectorMap.size());
        LOGGER.info("Registered {} number converters", (Object)this.numberConverterMap.size());
        LOGGER.info("Registered {} entry factories", (Object)this.entryFactoryMap.size());
        LOGGER.info("Registered {} function tooltips", (Object)this.functionTooltipMap.size());
        LOGGER.info("Registered {} condition tooltips", (Object)this.conditionTooltipMap.size());
        LOGGER.info("Registered {} ingredient tooltips", (Object)this.ingredientTooltipMap.size());
        LOGGER.info("Registered {} item sub predicate tooltips", (Object)this.itemSubPredicateTooltipMap.size());
        LOGGER.info("Registered {} entity sub predicate tooltips", (Object)this.entitySubPredicateTooltipMap.size());
        LOGGER.info("Registered {} data component type tooltips", (Object)this.dataComponentTypeTooltipMap.size());
        LOGGER.info("Registered {} chance modifiers", (Object)this.chanceModifierMap.size());
        LOGGER.info("Registered {} count modifiers", (Object)this.countModifierMap.size());
        LOGGER.info("Registered {} item stack modifiers", (Object)this.itemStackModifierMap.size());
        LOGGER.info("Registered {} loot modifiers", (Object)this.lootModifierMap.size());
        LOGGER.info("Registered {} item listing factories", (Object)this.itemListingFactoryMap.size());
    }

    public void printRuntimeInfo() {
        this.missingEntryFactories.forEach(t -> LOGGER.warn("Missing entry factory for {}", (Object)t.getName()));
        this.missingFunctionTooltips.forEach(t -> LOGGER.warn("Missing function tooltip for {}", (Object)t.getCanonicalName()));
        this.missingConditionTooltips.forEach(t -> LOGGER.warn("Missing condition tooltip for {}", (Object)t.getCanonicalName()));
        this.missingIngredientTooltips.forEach(t -> LOGGER.warn("Missing ingredient tooltip for {}", (Object)t.getCanonicalName()));
        this.missingItemSubPredicateTooltips.forEach(t -> LOGGER.warn("Missing item sub predicate tooltip for {}", (Object)t.getCanonicalName()));
        this.missingEntitySubPredicateTooltips.forEach(t -> LOGGER.warn("Missing entity sub predicate tooltip for {}", (Object)t.getCanonicalName()));
        this.missingDataComponentTypeTooltips.forEach(t -> LOGGER.warn("Missing data component type tooltip for {}", (Object)t.getCanonicalName()));
        this.missingItemListingFactories.forEach(t -> LOGGER.warn("Missing trade item listing for {}", (Object)t.getName()));
        this.missingNumberConverters.forEach(t -> LOGGER.warn("Missing number converters for {}", (Object)t.getName()));
        this.entryTracker.logStats();
        this.functionTracker.logStats();
        this.conditionTracker.logStats();
        this.ingredientTracker.logStats();
    }
}

