/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_106;
import net.minecraft.class_109;
import net.minecraft.class_114;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_125;
import net.minecraft.class_1322;
import net.minecraft.class_137;
import net.minecraft.class_141;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_182;
import net.minecraft.class_1887;
import net.minecraft.class_219;
import net.minecraft.class_225;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3670;
import net.minecraft.class_44;
import net.minecraft.class_5341;
import net.minecraft.class_5642;
import net.minecraft.class_5659;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_94;
import net.minecraft.class_9704;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getChance(IServerUtils utils, List<class_5341> conditions, float rawChance) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> chance = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (class_5341 condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getCount(IServerUtils utils, List<class_117> functions) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> count = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (class_117 function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static class_1799 getItemStack(IServerUtils utils, class_1799 itemStack, List<class_117> functions) {
        for (class_117 function : functions) {
            itemStack = utils.applyItemStackModifier(utils, function, itemStack);
        }
        return itemStack;
    }

    public static void applyRandomChance(IServerUtils utils, class_219 condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(utils.convertNumber(utils, condition.comp_2781()));
            }
        }
    }

    public static void applyRandomChanceWithLooting(IServerUtils utils, class_225 condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        class_6880 enchantment = condition.comp_2783();
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.comp_2865());
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                RangeValue value = new RangeValue();
                TooltipUtils.calculateCount(condition.comp_2866(), value, (int)entry.getKey());
                entry.getValue().multiply(value);
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.comp_2865());
            chance.put((class_6880<class_1887>)enchantment, levelMap);
            for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183(); ++level) {
                RangeValue value = new RangeValue();
                TooltipUtils.calculateCount(condition.comp_2866(), value, level);
                levelMap.put(level, new RangeValue(baseChance).multiply(value));
            }
        }
    }

    public static void applyTableBonus(IServerUtils utils, class_182 condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        block2: {
            class_6880 enchantment;
            block3: {
                enchantment = condition.comp_1867();
                if (condition.comp_1868().isEmpty()) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(((Float)condition.comp_1868().getFirst()).floatValue());
                if (condition.comp_1868().size() <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.comp_1868().size()) continue;
                    entry.getValue().multiply(((Float)condition.comp_1868().get(level)).floatValue());
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(((Float)condition.comp_1868().getFirst()).floatValue());
            chance.put((class_6880<class_1887>)enchantment, levelMap);
            for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183() && level < condition.comp_1868().size(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(((Float)condition.comp_1868().get(level)).floatValue()));
            }
        }
    }

    public static void applySetCount(IServerUtils utils, class_141 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        if (function.field_1047.isEmpty()) {
            for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.field_27909) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.field_1114));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.field_1114));
                }
            }
        }
    }

    public static void applyBonus(IServerUtils utils, class_94 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        block4: {
            if (!function.field_1047.isEmpty()) break block4;
            class_6880 enchantment = function.field_1011;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), (int)entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put((class_6880<class_1887>)enchantment, levelMap);
                for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IServerUtils utils, class_114 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> bonusCount) {
        if (function.field_1047.isEmpty()) {
            for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.field_1044.field_921), utils.convertNumber(utils, function.field_1044.field_920));
                }
            }
        }
    }

    public static void applyLootingEnchant(IServerUtils utils, class_125 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        block5: {
            if (!function.field_1047.isEmpty()) break block5;
            class_6880 enchantment = function.field_51798;
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.field_1082).multiply(entry.getKey().intValue()));
                    if (function.field_1083 <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.field_1083));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put((class_6880<class_1887>)enchantment, levelMap);
                for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.field_1082).multiply(level));
                    if (function.field_1083 > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.field_1083));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static class_1799 applyEnchantRandomlyItemStackModifier(IServerUtils utils, class_109 function, class_1799 itemStack) {
        if (itemStack.method_7923() && function.field_1047.isEmpty()) {
            List<class_6880> list;
            boolean isBook = itemStack.method_31574(class_1802.field_8529);
            boolean compatible = !isBook && function.field_51793;
            class_1799 finalItemStack = itemStack;
            Optional<class_6885.class_6886> enchantments = function.field_51792;
            if (enchantments.isEmpty() && (list = function.field_51792.map(class_6885::method_40239).orElseGet(() -> utils.lookupProvider().method_46762(class_7924.field_41265).method_42017().map(Function.identity())).filter(ref -> compatible || ((class_1887)ref.comp_349()).method_8192(finalItemStack)).toList()).size() == 1) {
                enchantments = Optional.of(class_6885.method_40246((class_6880[])new class_6880[]{list.getFirst()}));
            }
            if (enchantments.isPresent() && ((class_6885)enchantments.get()).method_40247() == 1 && ((class_1887)((class_6885)enchantments.get()).method_40240(0).comp_349()).method_8187() == ((class_1887)((class_6885)enchantments.get()).method_40240(0).comp_349()).method_8183()) {
                itemStack.method_7978(((class_6885)enchantments.get()).method_40240(0), ((class_1887)((class_6885)enchantments.get()).method_40240(0).comp_349()).method_8183());
            } else if (isBook) {
                itemStack = class_1802.field_8598.method_7854();
            } else {
                itemStack.method_57379(class_9334.field_49641, (Object)true);
            }
        }
        return itemStack;
    }

    @NotNull
    public static class_1799 applyEnchantWithLevelsItemStackModifier(IServerUtils utils, class_106 function, class_1799 itemStack) {
        if (itemStack.method_7923() && function.field_1047.isEmpty()) {
            if (itemStack.method_31574(class_1802.field_8529)) {
                itemStack = class_1802.field_8598.method_7854();
            } else {
                itemStack.method_57379(class_9334.field_49641, (Object)true);
            }
        }
        return itemStack;
    }

    public static class_1799 applySetAttributesItemStackModifier(IServerUtils utils, class_137 function, class_1799 itemStack) {
        if (function.field_1047.isEmpty()) {
            if (function.field_51360) {
                itemStack.method_57379(class_9334.field_49636, (Object)TooltipUtils.updateModifiers(function.field_1105, class_9285.field_49326));
            } else {
                itemStack.method_57368(class_9334.field_49636, (Object)class_9285.field_49326, modifiers -> {
                    if (modifiers.comp_2393().isEmpty()) {
                        return TooltipUtils.updateModifiers(function.field_1105, itemStack.method_7909().method_7844());
                    }
                    return TooltipUtils.updateModifiers(function.field_1105, modifiers);
                });
            }
        }
        return itemStack;
    }

    public static class_1799 applySetNameItemStackModifier(IServerUtils utils, class_3670 function, class_1799 itemStack) {
        if (function.field_1047.isEmpty() && function.field_16228.isPresent()) {
            itemStack.method_57379(function.field_50208.method_58734(), (Object)((class_2561)function.field_16228.get()));
        }
        return itemStack;
    }

    @NotNull
    public static class_1799 applySetEnchantmentsItemStackModifier(IServerUtils utils, class_5642 function, class_1799 itemStack) {
        if (itemStack.method_7923() && function.field_1047.isEmpty()) {
            if (itemStack.method_31574(class_1802.field_8529)) {
                itemStack = class_1802.field_8598.method_7854();
            } else {
                itemStack.method_57379(class_9334.field_49641, (Object)true);
            }
        }
        return itemStack;
    }

    public static class_1799 applyItemStackModifier(IServerUtils utils, class_117 function, class_1799 itemStack) {
        if (function instanceof class_120) {
            class_120 conditional = (class_120)function;
            if (!conditional.field_1047.isEmpty()) {
                return itemStack;
            }
        }
        itemStack = (class_1799)function.apply((Object)itemStack, null);
        return itemStack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void calculateCount(class_94 function, RangeValue value, int level) {
        class_94.class_96 class_962 = function.field_1009;
        Objects.requireNonNull(class_962);
        class_94.class_96 class_963 = class_962;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_94.class_98.class, class_94.class_95.class, class_94.class_100.class}, (Object)class_963, n)) {
            case 0: {
                class_94.class_98 ignored = (class_94.class_98)class_963;
                if (level <= 0) return;
                value.multiplyMax(level + 1);
                return;
            }
            case 1: {
                class_94.class_95 binomialWithBonusCount = (class_94.class_95)class_963;
                value.addMax(binomialWithBonusCount.comp_1848() + level);
                return;
            }
            case 2: {
                class_94.class_100 class_1002 = (class_94.class_100)class_963;
                try {
                    int n2;
                    int bonusMultiplier = n2 = class_1002.comp_1852();
                    if (level <= 0) return;
                    value.addMax(bonusMultiplier * level);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void calculateCount(class_9704 levelBasedValue, RangeValue v, int level) {
        block20: {
            v0 = levelBasedValue;
            Objects.requireNonNull(v0);
            var3_3 = v0;
            var4_5 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_9704.class_9706.class, class_9704.class_9705.class, class_9704.class_9707.class, class_9704.class_9709.class, class_9704.class_9708.class, class_9704.class_9819.class}, (Object)var3_3, var4_5)) {
                case 0: {
                    var5_6 = (class_9704.class_9706)var3_3;
                    value = var7_7 = var5_6.comp_2694();
                    v.multiply(value);
                    break;
                }
                case 1: {
                    var7_8 = (class_9704.class_9705)var3_3;
                    value = var11_10 = var7_8.comp_2691();
                    min = var11_11 = var7_8.comp_2692();
                    max = var11_11 = var7_8.comp_2693();
                    TooltipUtils.calculateCount(value, v, level);
                    v.clamp(min, max);
                    break;
                }
                case 2: {
                    var11_12 = (class_9704.class_9707)var3_3;
                    numerator = var14_16 = var11_12.comp_2695();
                    denominator = var14_16 = var11_12.comp_2696();
                    n = new RangeValue();
                    d = new RangeValue();
                    TooltipUtils.calculateCount(numerator, n, level);
                    TooltipUtils.calculateCount(denominator, d, level);
                    v.multiply(new RangeValue(n.min() / d.max(), n.max() / d.min()));
                    break;
                }
                case 3: {
                    var14_17 = (class_9704.class_9709)var3_3;
                    base = var17_22 = var14_17.comp_2698();
                    perLevelAboveFirst = var17_22 = var14_17.comp_2699();
                    v.multiply(new RangeValue(base).add(perLevelAboveFirst * (float)(level - 1)));
                    break;
                }
                case 4: {
                    var17_23 = (class_9704.class_9708)var3_3;
                    added = var19_25 = var17_23.comp_2697();
                    v.multiply(added + (float)class_3532.method_34954((int)level));
                    break;
                }
                case 5: {
                    var19_26 = (class_9704.class_9819)var3_3;
                    values = var22_28 = var19_26.comp_2862();
                    fallback = var22_28 = var19_26.comp_2863();
                    if (level >= values.size()) ** GOTO lbl65
                    v.multiply(((Float)values.get(level)).floatValue());
                    break;
lbl65:
                    // 1 sources

                    TooltipUtils.calculateCount((class_9704)fallback, v, level);
                    break;
                }
                default: {
                    v.set(new RangeValue(false, true));
                    break;
                }
            }
            break block20;
            catch (Throwable var3_4) {
                throw new MatchException(var3_4.toString(), var3_4);
            }
        }
    }

    private static class_9285 updateModifiers(List<class_137.class_138> modifiers, class_9285 itemAttributeModifiers) {
        for (class_137.class_138 modifier : modifiers) {
            class_2960 id = modifier.comp_1864();
            if (modifier.comp_1863().size() != 1 || modifier.comp_1862().method_365() != class_5659.field_27921) continue;
            class_9274 equipmentSlot = (class_9274)class_156.method_32309((List)modifier.comp_1863(), (class_5819)class_5819.method_43047());
            class_44 value = (class_44)modifier.comp_1862();
            itemAttributeModifiers = itemAttributeModifiers.method_57484(modifier.comp_1860(), new class_1322(id, (double)value.method_32454(null), modifier.comp_1861()), equipmentSlot);
        }
        return itemAttributeModifiers;
    }
}

