/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.mixin.MixinForgeInternalHandler;
import com.yanny.ali.platform.Services;
import com.yanny.ali.plugin.GlobalLootModifierUtils;
import com.yanny.ali.plugin.IForgePlugin;
import com.yanny.ali.plugin.client.widget.GlobalLootModifierWidget;
import com.yanny.ali.plugin.client.widget.SingletonWidget;
import com.yanny.ali.plugin.common.nodes.GlobalLootModifierNode;
import com.yanny.ali.plugin.common.nodes.SingletonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@AliEntrypoint
public class ForgePlugin
implements IPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getModId() {
        return "forge";
    }

    @Override
    public void registerClient(IClientRegistry registry) {
        registry.registerWidget(SingletonNode.ID, SingletonWidget::new);
        registry.registerWidget(GlobalLootModifierNode.ID, GlobalLootModifierWidget::new);
        registry.registerDataNode(SingletonNode.ID, SingletonNode::new);
        registry.registerDataNode(GlobalLootModifierNode.ID, GlobalLootModifierNode::new);
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        registry.registerConditionTooltip(CanToolPerformAction.class, ForgePlugin::getCanToolPerformActionTooltip);
        registry.registerConditionTooltip(LootTableIdCondition.class, ForgePlugin::getLootTableIdTooltip);
        registry.registerLootModifiers(ForgePlugin::registerLootModifiers);
    }

    @NotNull
    public static ITooltipNode getCanToolPerformActionTooltip(IServerUtils utils, CanToolPerformAction cond) {
        return utils.getValueTooltip(utils, cond.action.name()).build("ali.type.condition.can_tool_perform_action");
    }

    @NotNull
    public static ITooltipNode getLootTableIdTooltip(IServerUtils utils, LootTableIdCondition cond) {
        return utils.getValueTooltip(utils, cond.id()).build("ali.type.condition.loot_table_id");
    }

    private static List<ILootModifier<?>> registerLootModifiers(IServerUtils utils) {
        final HashMap glmMap = new HashMap();
        HashSet<Class> missingGLM = new HashSet<Class>();
        ArrayList lootModifiers = new ArrayList();
        IForgePlugin.IRegistry forgeRegistry = new IForgePlugin.IRegistry(){

            @Override
            public <T extends IGlobalLootModifier> void registerGlobalLootModifier(Class<T> type, BiFunction<IServerUtils, T, Optional<ILootModifier<?>>> getter) {
                glmMap.put(type, (u, t) -> (Optional)getter.apply((IServerUtils)u, (Object)t));
            }
        };
        for (IPlugin plugin : Services.getPlatform().getPlugins()) {
            if (!(plugin instanceof IForgePlugin)) continue;
            IForgePlugin forgePlugin = (IForgePlugin)plugin;
            forgePlugin.registerGLM(forgeRegistry);
        }
        LootModifierManager lootModifierManager = MixinForgeInternalHandler.getLootModifierManager();
        for (IGlobalLootModifier globalLootModifier : lootModifierManager.getAllLootMods()) {
            try {
                BiFunction getter = (BiFunction)glmMap.get(globalLootModifier.getClass());
                if (getter != null) {
                    Optional lootModifier = (Optional)getter.apply(utils, globalLootModifier);
                    if (lootModifier.isPresent()) {
                        lootModifiers.add((ILootModifier)lootModifier.get());
                        continue;
                    }
                    LOGGER.warn("Unable to locate destination for GLM {}", (Object)GlobalLootModifierUtils.getName(globalLootModifier));
                    continue;
                }
                Optional<ILootModifier<?>> modifier = GlobalLootModifierUtils.getMissingGlobalLootModifier(utils, globalLootModifier);
                missingGLM.add(globalLootModifier.getClass());
                if (modifier.isPresent()) {
                    lootModifiers.add(modifier.get());
                    continue;
                }
                LOGGER.warn("Unable to locate destination for auto GLM {}", (Object)GlobalLootModifierUtils.getName(globalLootModifier));
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.warn("Failed to add GLM with error {}", (Object)e.getMessage());
            }
        }
        missingGLM.forEach(c -> LOGGER.warn("Missing GLM for {}", (Object)c.getName()));
        return lootModifiers;
    }
}

