/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ReferenceNode
extends ListNode {
    public static final ResourceLocation ID = ResourceLocation.m_339182_((String)"ali", (String)"reference");
    private final ITooltipNode tooltip;
    private final float chance;

    public ReferenceNode(IServerUtils utils, NestedLootTable entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), entry.f_79677_.stream()).toList();
        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), entry.f_79636_.stream()).toList();
        LootTable lootTable = utils.getLootTable((Either<ResourceLocation, LootTable>)entry.f_314988_.mapLeft(ResourceKey::m_135782_));
        if (lootTable != null) {
            this.addChildren(new LootTableNode(utils, lootTable, chance * (float)entry.f_79675_ / (float)sumWeight, allFunctions, allConditions));
        } else {
            this.addChildren(new MissingNode(utils.getValueTooltip(utils, entry.f_314988_.mapLeft(ResourceKey::m_135782_)).build("ali.property.value.loot_table")));
        }
        this.chance = chance * (float)entry.f_79675_ / (float)sumWeight;
        this.tooltip = EntryTooltipUtils.getReferenceTooltip(entry, chance, sumWeight);
    }

    public ReferenceNode(IServerUtils utils, ResourceLocation table, List<LootItemCondition> conditions, ITooltipNode tooltip) {
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance = TooltipUtils.getChance(utils, conditions, 1.0f);
        LootTable lootTable = utils.getLootTable((Either<ResourceLocation, LootTable>)Either.left((Object)table));
        if (lootTable != null) {
            this.addChildren(new LootTableNode(utils, lootTable, 1.0f, Collections.emptyList(), conditions));
        } else {
            this.addChildren(new MissingNode(utils.getValueTooltip(utils, table).build("ali.property.value.loot_table")));
        }
        this.chance = chance.get(null).get(0).min();
        this.tooltip = tooltip;
    }

    public ReferenceNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.chance = buf.readFloat();
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public float getChance() {
        return this.chance;
    }
}

