/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.tooltip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ListTooltipNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ArrayTooltipNode
extends ListTooltipNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "array");
    private static final LoadingCache<CacheKey, ArrayTooltipNode> CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(data -> data != null ? new ArrayTooltipNode((CacheKey)data) : null));

    private ArrayTooltipNode(CacheKey cacheKey) {
        super(cacheKey.children);
    }

    public ArrayTooltipNode add(ITooltipNode node) {
        super.addNode(node);
        return this;
    }

    @Override
    void encodeNode(FriendlyByteBuf buf) {
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public String toString() {
        return "ArrayTooltipNode{children=" + String.valueOf(this.getChildren()) + "}";
    }

    @NotNull
    public static Builder array() {
        return new Builder();
    }

    @NotNull
    public static ArrayTooltipNode decode(IClientUtils utils, FriendlyByteBuf buf) {
        List<ITooltipNode> children = ListTooltipNode.decodeChildren(utils, buf);
        CacheKey cacheKey = new CacheKey(children);
        try {
            return (ArrayTooltipNode)CACHE.get((Object)cacheKey);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private record CacheKey(List<ITooltipNode> children) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.children, cacheKey.children);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.children);
        }
    }

    public static class Builder {
        private final List<ITooltipNode> children = new ArrayList<ITooltipNode>();

        public Builder add(ITooltipNode node) {
            this.children.add(node);
            return this;
        }

        public ArrayTooltipNode build() {
            CacheKey cacheKey = new CacheKey((List<ITooltipNode>)ImmutableList.copyOf(this.children));
            try {
                return (ArrayTooltipNode)CACHE.get((Object)cacheKey);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

