/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ItemStackNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"ali", (String)"item_stack");
    private final ITooltipNode tooltip;
    private final ItemStack itemStack;
    private final RangeValue count;

    public ItemStackNode(IServerUtils utils, ItemStack item, RangeValue count) {
        this(utils, item, count, EmptyTooltipNode.EMPTY);
    }

    public ItemStackNode(IServerUtils ignoredUtils, ItemStack item, RangeValue count, ITooltipNode tooltip) {
        this.itemStack = item;
        this.tooltip = tooltip;
        this.count = count;
    }

    public ItemStackNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        this.itemStack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue((FriendlyByteBuf)buf);
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return Either.left((Object)this.itemStack);
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return Collections.emptyList();
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return Collections.emptyList();
    }

    @Override
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return 1.0f;
    }

    @Override
    public void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.itemStack);
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode((FriendlyByteBuf)buf);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

