/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.mojang.authlib.properties.Property;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.CollectionContentsPredicate;
import net.minecraft.advancements.critereon.CollectionCountsPredicate;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericTooltipUtils {
    @NotNull
    public static ITooltipNode getMissingEntryTooltip(IServerUtils utils, LootPoolEntryContainer entry) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getEntryTypeTooltip(utils, entry.getType());
        TooltipUtils.addObjectFields(utils, tooltip, entry, CompositeEntryBase.class);
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getMissingFunctionTooltip(IServerUtils utils, LootItemFunction function) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getFunctionTypeTooltip(utils, function.getType());
        TooltipUtils.addObjectFields(utils, tooltip, function, LootItemFunction.class);
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getMissingConditionTooltip(IServerUtils utils, LootItemCondition condition) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getConditionTypeTooltip(utils, condition.getType());
        TooltipUtils.addObjectFields(utils, tooltip, condition, LootItemCondition.class);
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getMissingItemListingTooltip(IServerUtils utils, VillagerTrades.ItemListing itemListing) {
        ValueTooltipNode.Builder tooltip = ValueTooltipNode.value(itemListing.getClass().getName());
        TooltipUtils.addObjectFields(utils, tooltip, itemListing, VillagerTrades.ItemListing.class);
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getConditionListTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemCondition condition : conditions) {
            array.add(utils.getConditionTooltip(utils, condition));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.conditions")).add(GenericTooltipUtils.getConditionListTooltip(utils, conditions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getSubConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getFunctionListTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemFunction function : functions) {
            array.add(utils.getFunctionTooltip(utils, function));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getFunctionsTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        if (!functions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.functions")).add(GenericTooltipUtils.getFunctionListTooltip(utils, functions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        Optional maxValue;
        String name;
        block5: {
            Optional minValue;
            Optional optional;
            StatePropertiesPredicate.ExactMatcher exactMatcher;
            name = propertyMatcher.name();
            StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.valueMatcher();
            if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
                String string;
                exactMatcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
                String value = string = exactMatcher.value();
                return ValueTooltipNode.keyValue(name, value).build("ali.property.value.null");
            }
            StatePropertiesPredicate.ValueMatcher valueMatcher2 = propertyMatcher.valueMatcher();
            if (!(valueMatcher2 instanceof StatePropertiesPredicate.RangedMatcher)) return EmptyTooltipNode.EMPTY;
            exactMatcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher2;
            try {
                minValue = optional = exactMatcher.minValue();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            maxValue = optional = exactMatcher.maxValue();
            if (!minValue.isPresent()) break block5;
            if (!maxValue.isPresent()) return ValueTooltipNode.value(name, minValue.get()).build("ali.property.value.ranged_property_gte");
            return ValueTooltipNode.value(name, minValue.get(), maxValue.get()).build("ali.property.value.ranged_property_both");
        }
        if (!maxValue.isPresent()) return ValueTooltipNode.value(name).build("ali.property.value.ranged_property_any");
        return ValueTooltipNode.value(name, maxValue.get()).build("ali.property.value.ranged_property_lte");
    }

    @NotNull
    public static ITooltipNode getStatMatcherTooltip(IServerUtils utils, PlayerPredicate.StatMatcher<?> stat) {
        ITooltipNode tooltip;
        String key = ValueTooltipNode.translate(((TranslatableContents)stat.type().getDisplayName().getContents()).getKey());
        Holder value = stat.value();
        Object object = value.value();
        if (object instanceof Item) {
            Item item = (Item)object;
            tooltip = utils.getValueTooltip(utils, item).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.item");
        } else {
            object = value.value();
            if (object instanceof Block) {
                Block block = (Block)object;
                tooltip = utils.getValueTooltip(utils, block).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.block");
            } else {
                object = value.value();
                if (object instanceof EntityType) {
                    EntityType entityType = (EntityType)object;
                    tooltip = utils.getValueTooltip(utils, entityType).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.entity_type");
                } else {
                    object = value.value();
                    if (object instanceof ResourceLocation) {
                        ResourceLocation resourceLocation = (ResourceLocation)object;
                        tooltip = utils.getValueTooltip(utils, resourceLocation).add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(GenericTooltipUtils.getTranslationKey(resourceLocation)), GenericTooltipUtils.toString(stat.range())).build("ali.property.value.null")).build("ali.property.value.id");
                    } else {
                        tooltip = EmptyTooltipNode.EMPTY;
                    }
                }
            }
        }
        return tooltip;
    }

    @NotNull
    public static <T> IKeyTooltipNode getStandaloneTooltip(IServerUtils utils, String value, Optional<ListOperation.StandAlone<T>> predicate) {
        if (predicate.isPresent()) {
            ListOperation.StandAlone<T> s = predicate.get();
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getCollectionTooltip(utils, value, s.value()).build("ali.property.branch.values")).add(utils.getValueTooltip(utils, s.operation()).build("ali.property.value.list_operation"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getDataComponentExactPredicateTooltip(IServerUtils utils, DataComponentExactPredicate dataComponentMatchers) {
        return utils.getValueTooltip(utils, dataComponentMatchers.expectedComponents).build("ali.property.branch.expected_components");
    }

    @NotNull
    public static <T> IKeyTooltipNode getFilterableTooltip(IServerUtils utils, String value, Collection<Filterable<T>> data) {
        BranchTooltipNode.Builder tooltips = BranchTooltipNode.branch();
        for (Filterable<T> d : data) {
            tooltips.add(BranchTooltipNode.branch().add(utils.getValueTooltip(utils, d.raw()).build("ali.property.value.raw")).add(utils.getValueTooltip(utils, d.filtered()).build("ali.property.value.filtered")).build(value));
        }
        return tooltips;
    }

    @NotNull
    public static <T> IKeyTooltipNode getCollectionTooltip(IServerUtils utils, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, String value, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build(value));
        }
        return tooltip;
    }

    @NotNull
    public static <K, V> IKeyTooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<ResourceKey<Recipe<?>>, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey().location(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getStringEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, String> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, IntRange> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.limit")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue().amplifier()).build("ali.property.value.amplifier")).add(utils.getValueTooltip(utils, entry.getValue().duration()).build("ali.property.value.duration")).add(utils.getValueTooltip(utils, entry.getValue().ambient()).build("ali.property.value.is_ambient")).add(utils.getValueTooltip(utils, entry.getValue().visible()).build("ali.property.value.is_visible")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<Holder<Enchantment>, NumberProvider> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.levels")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getDataComponentEntryTooltip(IServerUtils utils, Map.Entry<DataComponentType<?>, Boolean> entry) {
        return RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.value")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(GenericTooltipUtils.getAdvancementPredicateTooltip(utils, entry.getValue())).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMapDecorationEntryTooltip(IServerUtils utils, Map.Entry<String, MapDecorations.Entry> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.null")).build("ali.property.value.decoration");
    }

    @NotNull
    public static ITooltipNode getBlockPropertyEntryTooltip(IServerUtils utils, Map.Entry<Holder<Block>, net.minecraft.world.level.block.state.properties.Property<?>> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.property")).build("ali.property.value.block");
    }

    @NotNull
    public static ITooltipNode getPropertiesEntryTooltip(IServerUtils utils, Map.Entry<String, Collection<Property>> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.property", entry.getValue()).build("ali.property.branch.properties")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelEntryTooltip(IServerUtils utils, Map.Entry<Holder<Enchantment>, Integer> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.level")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getDataComponentPatchEntryTooltip(IServerUtils utils, Map.Entry<DataComponentType<?>, Optional<?>> entry) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, entry.getKey());
        entry.getValue().ifPresent(v -> tooltip.add(utils.getDataComponentTypeTooltip(utils, (DataComponentType)entry.getKey(), v)));
        if (entry.getValue().isEmpty()) {
            tooltip.add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.removed"));
        }
        return tooltip.build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getDataComponentPredicateEntryTooltip(IServerUtils utils, Map.Entry<DataComponentPredicate.Type<?>, DataComponentPredicate> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getDataComponentPredicateTooltip(utils, entry.getValue())).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getSlotRangePredicateEntryTooltip(IServerUtils utils, Map.Entry<SlotRange, ItemPredicate> entry) {
        return ValueTooltipNode.keyValue(entry.getKey().toString(), entry.getKey().slots().toString()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.branch.predicate")).build("ali.property.value.null");
    }

    @NotNull
    public static <V, T extends Registry<V>> IKeyTooltipNode getRegistryTooltip(IServerUtils utils, ResourceKey<T> registry, V value) {
        Optional<Holder.Reference> first;
        Optional lookup;
        HolderLookup.Provider provider = utils.lookupProvider();
        if (provider != null && (lookup = provider.lookup(registry)).isPresent() && (first = ((HolderLookup.RegistryLookup)lookup.get()).listElements().filter(l -> l.value() == value).findFirst()).isPresent()) {
            return utils.getValueTooltip(utils, Objects.requireNonNull(first.get().key()));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <A, B extends Predicate<A>> IKeyTooltipNode getCollectionPredicateTooltip(IServerUtils utils, String value, Optional<CollectionPredicate<A, B>> optional) {
        if (optional.isPresent()) {
            CollectionPredicate<A, B> predicate = optional.get();
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getCollectionContentsPredicateTooltip(utils, value, predicate.contains()).build("ali.property.branch.contains")).add(GenericTooltipUtils.getCollectionCountsPredicateTooltip(utils, value, predicate.counts()).build("ali.property.branch.counts")).add(utils.getValueTooltip(utils, predicate.size()).build("ali.property.value.size"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <A, B extends Predicate<A>> IKeyTooltipNode getCollectionContentsPredicateTooltip(IServerUtils utils, String value, Optional<CollectionContentsPredicate<A, B>> predicate) {
        return predicate.map(p -> GenericTooltipUtils.getCollectionTooltip(utils, value, p.unpack())).orElse(EmptyTooltipNode.empty());
    }

    @NotNull
    public static <A, B extends Predicate<A>> IKeyTooltipNode getCollectionCountsPredicateTooltip(IServerUtils utils, String value, Optional<CollectionCountsPredicate<A, B>> predicate) {
        return predicate.map(p -> GenericTooltipUtils.getCollectionTooltip(utils, value, p.unpack())).orElse(EmptyTooltipNode.empty());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ITooltipNode getAdvancementPredicateTooltip(IServerUtils utils, PlayerPredicate.AdvancementPredicate predicate) {
        if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
            boolean bl;
            PlayerPredicate.AdvancementDonePredicate advancementDonePredicate = (PlayerPredicate.AdvancementDonePredicate)predicate;
            boolean state = bl = advancementDonePredicate.state();
            return utils.getValueTooltip(utils, state).build("ali.property.value.done");
        }
        if (!(predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate)) return EmptyTooltipNode.EMPTY;
        PlayerPredicate.AdvancementCriterionsPredicate advancementCriterionsPredicate = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
        try {
            Object2BooleanMap object2BooleanMap;
            Object2BooleanMap criterions = object2BooleanMap = advancementCriterionsPredicate.criterions();
            return GenericTooltipUtils.getMapTooltip(utils, criterions, GenericTooltipUtils::getCriterionEntryTooltip).build("ali.property.branch.criterions");
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @NotNull
    public static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.min();
        Optional max = doubles.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    public static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.min();
        Optional max = ints.max();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static String getTranslationKey(ResourceLocation location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

