/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.pip;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yanny.ali.pip.BlockRenderState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class BlockPictureInPictureRenderer
extends PictureInPictureRenderer<BlockRenderState> {
    private static final float RENDER_SIZE = 24.0f;
    private static final ItemTransform DEFAULT_TRANSFORM = new ItemTransform((Vector3fc)new Vector3f(30.0f, 225.0f, 0.0f), (Vector3fc)new Vector3f(), (Vector3fc)new Vector3f(0.625f, 0.625f, 0.625f));
    private static final Quaternionfc LIGHT_FIX_ROT = Axis.YP.rotationDegrees(285.0f);
    private static final RandomSource RANDOM = RandomSource.create();

    public BlockPictureInPictureRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    protected void renderToTexture(BlockRenderState renderState, PoseStack poseStack) {
        float scale = renderState.scale();
        BlockState state = renderState.state();
        Level fakeLevel = renderState.level();
        poseStack.scale(24.0f * scale, -24.0f * scale, -24.0f * scale);
        DEFAULT_TRANSFORM.apply(false, poseStack.last());
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.last().normal().rotate(LIGHT_FIX_ROT);
        poseStack.translate(-0.5, -0.5, -0.5);
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockStateModel model = blockRenderer.getBlockModel(state);
        List modelParts = model.collectParts(RANDOM);
        RANDOM.setSeed(state.getSeed(BlockPos.ZERO));
        blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)fakeLevel, modelParts, state, BlockPos.ZERO, poseStack, this.bufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)ChunkSectionLayer.SOLID)), false, OverlayTexture.NO_OVERLAY);
    }

    protected float getTranslateY(int height, int guiScale) {
        return (float)height / 2.0f;
    }

    @NotNull
    protected String getTextureLabel() {
        return "block block-in-ui";
    }

    @NotNull
    public Class<BlockRenderState> getRenderStateClass() {
        return BlockRenderState.class;
    }
}

