/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class DynamicNode
implements IDataNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "dynamic");
    private final ITooltipNode tooltip;
    private final float chance;

    public DynamicNode(IServerUtils utils, DynamicLoot entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), entry.f_79677_.stream()).toList();
        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), entry.f_79636_.stream()).toList();
        this.chance = chance * (float)entry.f_79675_ / (float)sumWeight;
        this.tooltip = EntryTooltipUtils.getDynamicTooltip(utils, entry, chance, sumWeight, allFunctions, allConditions);
    }

    public DynamicNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.chance = buf.readFloat();
    }

    @Override
    public void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public float getChance() {
        return this.chance;
    }
}

