/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericTooltipUtils {
    @NotNull
    public static ITooltipNode getMissingFunction(IServerUtils utils, LootItemFunction function) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getFunctionTypeTooltip(utils, function.m_7162_());
        Field[] fields = function.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(function));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getMissingCondition(IServerUtils utils, LootItemCondition condition) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getConditionTypeTooltip(utils, condition.m_7940_());
        Field[] fields = condition.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(condition));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getConditionListTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemCondition condition : conditions) {
            array.add(utils.getConditionTooltip(utils, condition));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.conditions")).add(GenericTooltipUtils.getConditionListTooltip(utils, conditions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getSubConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getFunctionListTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (LootItemFunction function : functions) {
            array.add(utils.getFunctionTooltip(utils, function));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getFunctionsTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        if (!functions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.functions")).add(GenericTooltipUtils.getFunctionListTooltip(utils, functions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        String name = propertyMatcher.f_67715_();
        StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.f_291902_();
        if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
            StatePropertiesPredicate.ExactMatcher matcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
            return ValueTooltipNode.keyValue(name, matcher.f_290506_()).build("ali.property.value.null");
        }
        valueMatcher = propertyMatcher.f_291902_();
        if (valueMatcher instanceof StatePropertiesPredicate.RangedMatcher) {
            StatePropertiesPredicate.RangedMatcher matcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
            Optional min = matcher.f_291542_();
            Optional max = matcher.f_291806_();
            if (min.isPresent()) {
                if (max.isPresent()) {
                    return ValueTooltipNode.value(name, min.get(), max.get()).build("ali.property.value.ranged_property_both");
                }
                return ValueTooltipNode.value(name, min.get()).build("ali.property.value.ranged_property_gte");
            }
            if (max.isPresent()) {
                return ValueTooltipNode.value(name, max.get()).build("ali.property.value.ranged_property_lte");
            }
            return ValueTooltipNode.value(name).build("ali.property.value.ranged_property_any");
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getStatMatcherTooltip(IServerUtils utils, PlayerPredicate.StatMatcher<?> stat) {
        ITooltipNode tooltip;
        String key = ValueTooltipNode.translate(((TranslatableContents)stat.f_290937_().m_12905_().m_214077_()).m_237508_());
        Holder value = stat.f_291891_();
        Object object = value.m_203334_();
        if (object instanceof Item) {
            Item item = (Item)object;
            tooltip = utils.getValueTooltip(utils, item).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.f_291204_())).build("ali.property.value.null")).build("ali.property.value.item");
        } else {
            object = value.m_203334_();
            if (object instanceof Block) {
                Block block = (Block)object;
                tooltip = utils.getValueTooltip(utils, block).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.f_291204_())).build("ali.property.value.null")).build("ali.property.value.block");
            } else {
                object = value.m_203334_();
                if (object instanceof EntityType) {
                    EntityType entityType = (EntityType)object;
                    tooltip = utils.getValueTooltip(utils, entityType).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.f_291204_())).build("ali.property.value.null")).build("ali.property.value.entity_type");
                } else {
                    object = value.m_203334_();
                    if (object instanceof ResourceLocation) {
                        ResourceLocation resourceLocation = (ResourceLocation)object;
                        tooltip = utils.getValueTooltip(utils, resourceLocation).add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(GenericTooltipUtils.getTranslationKey(resourceLocation)), GenericTooltipUtils.toString(stat.f_291204_())).build("ali.property.value.null")).build("ali.property.value.id");
                    } else {
                        tooltip = EmptyTooltipNode.EMPTY;
                    }
                }
            }
        }
        return tooltip;
    }

    @NotNull
    public static <T> IKeyTooltipNode getCollectionTooltip(IServerUtils utils, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, String value, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build(value));
        }
        return tooltip;
    }

    @NotNull
    public static <K, V> IKeyTooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<ResourceLocation, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, IntRange> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.limit")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue().f_56566_()).build("ali.property.value.amplifier")).add(utils.getValueTooltip(utils, entry.getValue().f_56567_()).build("ali.property.value.duration")).add(utils.getValueTooltip(utils, entry.getValue().f_56568_()).build("ali.property.value.is_ambient")).add(utils.getValueTooltip(utils, entry.getValue().f_56569_()).build("ali.property.value.is_visible")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<Holder<Enchantment>, NumberProvider> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.levels")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, entry.getKey());
        IKeyTooltipNode value = utils.getValueTooltip(utils, entry.getValue());
        if (value instanceof ValueTooltipNode.Builder) {
            tooltip.add(value.build("ali.property.value.done"));
        } else {
            tooltip.add(value.build("ali.property.branch.criterions"));
        }
        return tooltip.build("ali.property.value.null");
    }

    @NotNull
    public static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.m_293284_();
        Optional max = doubles.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    public static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.m_293284_();
        Optional max = ints.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static String getTranslationKey(ResourceLocation location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

