/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_117;
import net.minecraft.class_1887;
import net.minecraft.class_2588;
import net.minecraft.class_5341;
import net.minecraft.class_67;
import net.minecraft.class_6880;
import net.minecraft.class_83;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;

public class EntryTooltipUtils {
    @NotNull
    public static ITooltipNode getLootTableTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.all");
    }

    @NotNull
    public static ITooltipNode getReferenceTooltip(class_83 entry, float chance, int sumWeight) {
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.all")).add(EntryTooltipUtils.getQualityTooltip(entry.field_994)).add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.field_995 / (float)sumWeight * 100.0f))).build();
    }

    @NotNull
    public static ITooltipNode getLootPoolTooltip(RangeValue rolls, RangeValue bonusRolls) {
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.random")).add(EntryTooltipUtils.getRolls(rolls, bonusRolls)).build();
    }

    @NotNull
    public static ITooltipNode getAlternativesTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.alternatives");
    }

    @NotNull
    public static ITooltipNode getDynamicTooltip(IServerUtils utils, class_67 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.dynamic")).add(EntryTooltipUtils.getQualityTooltip(entry.field_994)).add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.field_995 / (float)sumWeight * 100.0f))).add(GenericTooltipUtils.getConditionsTooltip(utils, conditions)).add(GenericTooltipUtils.getFunctionsTooltip(utils, functions)).build();
    }

    @NotNull
    public static ITooltipNode getGroupTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.all");
    }

    @NotNull
    public static ITooltipNode getSequentialTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.sequence");
    }

    @NotNull
    public static ITooltipNode getEmptyTooltip(IServerUtils utils, class_85 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        ArrayList<class_117> allFunctions = new ArrayList<class_117>(functions);
        ArrayList<class_5341> allConditions = new ArrayList<class_5341>(conditions);
        allFunctions.addAll(entry.field_996);
        allConditions.addAll(entry.field_988);
        float rawChance = chance * (float)entry.field_995 / (float)sumWeight;
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.empty")).add(EntryTooltipUtils.getQualityTooltip(entry.field_994)).add(EntryTooltipUtils.getChanceTooltip(chanceMap)).add(GenericTooltipUtils.getConditionsTooltip(utils, allConditions)).add(GenericTooltipUtils.getFunctionsTooltip(utils, allFunctions)).build();
    }

    @NotNull
    public static ITooltipNode getSingletonTooltip(IServerUtils utils, class_85 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        ArrayList<class_117> allFunctions = new ArrayList<class_117>(functions);
        ArrayList<class_5341> allConditions = new ArrayList<class_5341>(conditions);
        allFunctions.addAll(entry.field_996);
        allConditions.addAll(entry.field_988);
        float rawChance = chance * (float)entry.field_995 / (float)sumWeight;
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> countMap = TooltipUtils.getCount(utils, allFunctions);
        return EntryTooltipUtils.getTooltip(utils, entry.field_994, chanceMap, countMap, allFunctions, allConditions);
    }

    @NotNull
    public static ITooltipNode getTooltip(IServerUtils utils, int quality, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> functions, List<class_5341> conditions) {
        return ArrayTooltipNode.array().add(EntryTooltipUtils.getQualityTooltip(quality)).add(EntryTooltipUtils.getChanceTooltip(chance)).add(EntryTooltipUtils.getCountTooltip(count)).add(GenericTooltipUtils.getConditionsTooltip(utils, conditions)).add(GenericTooltipUtils.getFunctionsTooltip(utils, functions)).build();
    }

    @NotNull
    public static ITooltipNode getQualityTooltip(int quality) {
        if (quality != 0) {
            return ValueTooltipNode.value(quality).build("ali.description.quality");
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getChanceTooltip(Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        RangeValue defaultChance = chance.get(null).get(0);
        if (!defaultChance.isRange() && (double)defaultChance.max() > 99.99999) {
            return EmptyTooltipNode.EMPTY;
        }
        ValueTooltipNode.Builder tooltip = ValueTooltipNode.value(chance.get(null).get(0), "%");
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceEntry : chance.entrySet()) {
            class_6880<class_1887> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                String key = ((class_2588)((class_1887)enchantment.comp_349()).comp_2686().method_10851()).method_11022();
                RangeValue value = levelEntry.getValue();
                tooltip.add(ValueTooltipNode.value(value.toString() + "%", ValueTooltipNode.translate(key), ValueTooltipNode.translate("enchantment.level." + level)).build("ali.description.chance_bonus"));
            }
        }
        return tooltip.build("ali.description.chance");
    }

    @NotNull
    public static ITooltipNode getCountTooltip(Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        ValueTooltipNode.Builder tooltip = ValueTooltipNode.value(count.get(null).get(0));
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceEntry : count.entrySet()) {
            class_6880<class_1887> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                String key = ((class_2588)((class_1887)enchantment.comp_349()).comp_2686().method_10851()).method_11022();
                RangeValue value = levelEntry.getValue();
                tooltip.add(ValueTooltipNode.value(value, ValueTooltipNode.translate(key), ValueTooltipNode.translate("enchantment.level." + level)).build("ali.description.count_bonus"));
            }
        }
        return tooltip.build("ali.description.count");
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getBaseMap(float value) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> map = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(value)));
        return map;
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getBaseMap(float min, float max) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> map = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(min, max)));
        return map;
    }

    @NotNull
    public static ITooltipNode getRolls(RangeValue rolls, RangeValue bonusRolls) {
        return ValueTooltipNode.value(EntryTooltipUtils.getTotalRolls(rolls, bonusRolls).toIntString(), "x").build("ali.description.rolls");
    }

    private static RangeValue getTotalRolls(RangeValue rolls, RangeValue bonusRolls) {
        if (bonusRolls.min() > 0.0f || bonusRolls.max() > 0.0f) {
            return new RangeValue(bonusRolls).add(rolls);
        }
        return rolls;
    }
}

