/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.platform;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.pip.BlockRenderState;
import com.yanny.ali.platform.services.IPlatformHelper;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_332;
import org.slf4j.Logger;

public class FabricPlatformHelper
implements IPlatformHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public List<IPlugin> getPlugins() {
        LinkedList<IPlugin> plugins = new LinkedList<IPlugin>();
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("ali", IPlugin.class)) {
            try {
                IPlugin plugin = (IPlugin)container.getEntrypoint();
                if (!FabricLoader.getInstance().isModLoaded(plugin.getModId())) continue;
                plugins.add(plugin);
                LOGGER.info("Registered ALI plugin [{}] {}", (Object)plugin.getModId(), (Object)plugin.getClass().getCanonicalName());
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to load plugin with error: {}", (Object)t.getMessage());
                t.printStackTrace();
            }
        }
        LOGGER.info("Found {} plugin(s)", (Object)plugins.size());
        return plugins;
    }

    @Override
    public void renderBlockInGui(class_332 guiGraphics, BlockRenderState renderState) {
    }
}

