/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2477;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4048;
import net.minecraft.class_490;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import oshi.util.tuples.Pair;

public class GenericUtils {
    private static final class_2960 TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = class_310.method_1551().field_1772.method_1727("...");

    public static void renderEntity(class_1297 entity, Rect bounds, int fullWidth, class_332 guiGraphics, int mouseX, int mouseY) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_25302(class_10799.field_56883, TEXTURE_LOC, bounds.x(), bounds.y(), 0.0f, 36.0f, bounds.width(), bounds.height(), 36, 36, 256, 256);
            class_4048 dimensions = entity.method_5864().method_18386();
            GenericUtils.renderEntityInInventoryFollowsMouse(guiGraphics, bounds.x() + 1, bounds.y() + 1, bounds.right() - 1, bounds.bottom() - 1, (int)Math.min(20.0f / dimensions.comp_2186(), 20.0f / dimensions.comp_2185()), 0.0625f, mouseX, mouseY, livingEntity);
            guiGraphics.method_51448().popMatrix();
        }
    }

    @NotNull
    public static class_2561 ellipsis(String text, String fallback, int maxWidth) {
        class_327 font = class_310.method_1551().field_1772;
        text = class_2477.method_10517().method_4679(text, GenericUtils.getFallbackText(fallback));
        if (font.method_1727(text) > maxWidth) {
            int index = 20;
            while (font.method_1727(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return class_2561.method_43470((String)(text.substring(0, index) + "..."));
        }
        return class_2561.method_43470((String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Map<class_2960, LootData>, Map<class_2960, TradeData>> decompressLootData(byte[] fullCompressedData, class_5455 registryAccess) {
        HashMap<class_2960, LootData> lootData = new HashMap<class_2960, LootData>();
        HashMap<class_2960, TradeData> tradeData = new HashMap<class_2960, TradeData>();
        ByteArrayInputStream bis = new ByteArrayInputStream(fullCompressedData);
        ByteBuf decompressedBuf = Unpooled.buffer();
        try (GZIPInputStream gzip = new GZIPInputStream(bis);){
            decompressedBuf.writeBytes(gzip.readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        class_9129 readerBuf = new class_9129(decompressedBuf, registryAccess);
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            lootData.putAll(((ArrayList)readerBuf.method_34068(ArrayList::new, b -> {
                class_2960 location = b.method_10810();
                Object dataNode = utils.getDataNodeFactory(LootTableNode.ID).create(utils, (class_9129)b);
                List items = (List)class_1799.field_49269.decode((Object)((class_9129)b));
                return new AbstractMap.SimpleEntry<class_2960, LootData>(location, new LootData((IDataNode)dataNode, items));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            tradeData.putAll(((ArrayList)readerBuf.method_34068(ArrayList::new, b -> {
                class_2960 location = b.method_10810();
                Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, (class_9129)b);
                List<class_1792> inputs = ((ArrayList)b.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).toList();
                List<class_1792> outputs = ((ArrayList)b.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).toList();
                return new AbstractMap.SimpleEntry<class_2960, TradeData>(location, new TradeData((IDataNode)dataNode, inputs, outputs));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, readerBuf);
            List<class_1792> inputs = ((ArrayList)readerBuf.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).toList();
            List<class_1792> outputs = ((ArrayList)readerBuf.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).toList();
            tradeData.put(class_2960.method_60656((String)"empty"), new TradeData((IDataNode)dataNode, inputs, outputs));
        }
        finally {
            readerBuf.release();
        }
        return new Pair(lootData, tradeData);
    }

    public static void renderEntityInInventoryFollowsMouse(class_332 guiGraphics, int left, int top, int right, int bottom, int size, float scale, float mouseX, float mouseY, class_1309 entity) {
        float hCenter = (float)(left + right) / 2.0f;
        float vCenter = (float)(top + bottom) / 2.0f;
        float xRotation = (float)Math.atan((hCenter - mouseX) / 40.0f);
        float yRotation = (float)Math.atan((vCenter - mouseY) / 40.0f);
        float yBodyRot = entity.field_6283;
        float entityYRot = entity.method_36454();
        float entityXRot = entity.method_36455();
        float yHeadRotO = entity.field_6259;
        float yHeadRot = entity.field_6241;
        Quaternionf rotateZ = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf rotateX = new Quaternionf().rotateX(yRotation * 20.0f * ((float)Math.PI / 180));
        rotateZ.mul((Quaternionfc)rotateX);
        guiGraphics.method_44379(left, top, right, bottom);
        entity.field_6283 = 180.0f + xRotation * 20.0f;
        entity.method_36456(180.0f + xRotation * 40.0f);
        entity.method_36457(-yRotation * 20.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        float entityScale = entity.method_55693();
        Vector3f $$22 = new Vector3f(0.0f, entity.method_17682() / 2.0f + scale * entityScale, 0.0f);
        float $$23 = (float)size / entityScale;
        int x = (int)guiGraphics.method_51448().m20();
        int y = (int)guiGraphics.method_51448().m21();
        class_490.method_48472((class_332)guiGraphics, (int)(left + x), (int)(top + y), (int)(right + x), (int)(bottom + y), (float)$$23, (Vector3f)$$22, (Quaternionf)rotateZ, (Quaternionf)rotateX, (class_1309)entity);
        entity.field_6283 = yBodyRot;
        entity.method_36456(entityYRot);
        entity.method_36457(entityXRot);
        entity.field_6259 = yHeadRotO;
        entity.field_6241 = yHeadRot;
        guiGraphics.method_44380();
    }

    public static void processData(class_638 level, AliClientRegistry clientRegistry, AliConfig config, byte[] fullCompressedData, QuadConsumer<IDataNode, class_2960, class_2248, List<class_1799>> blockConsumer, QuadConsumer<IDataNode, class_2960, class_1299<?>, List<class_1799>> entityConsumer, TriConsumer<IDataNode, class_2960, List<class_1799>> gameplayConsumer, QuadConsumer<IDataNode, class_2960, List<class_1799>, List<class_1799>> traderConsumer, QuadConsumer<IDataNode, class_2960, List<class_1799>, List<class_1799>> wanderingTraderConsumer) {
        List<class_1799> outputs;
        List<class_1799> inputs;
        TradeData tradeEntry;
        class_2960 location;
        Pair<Map<class_2960, LootData>, Map<class_2960, TradeData>> pair = GenericUtils.decompressLootData(fullCompressedData, level.method_30349());
        Map lootData = (Map)pair.getA();
        Map tradeData = (Map)pair.getB();
        for (class_2248 block : class_7923.field_41175) {
            block.method_26162().ifPresent(resourceKey -> {
                class_2960 location = resourceKey.method_29177();
                LootData data = (LootData)lootData.get(location);
                if (data != null) {
                    blockConsumer.accept(data.node, location, block, data.items);
                    lootData.remove(location);
                }
            });
        }
        for (class_1299 entityType : class_7923.field_41177) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)class_7923.field_41177.method_10221((Object)entityType)))) {
                entityType.method_16351().ifPresent(lootTableResourceKey -> lootData.remove(lootTableResourceKey.method_29177()));
                continue;
            }
            List<class_1297> list = clientRegistry.createEntities(entityType, (class_1937)level);
            for (class_1297 entity : list) {
                if (!(entity instanceof class_1308)) continue;
                class_1308 mob = (class_1308)entity;
                mob.method_5991().ifPresent(resourceKey -> {
                    class_2960 location = resourceKey.method_29177();
                    LootData data = (LootData)lootData.get(location);
                    if (data != null) {
                        entityConsumer.accept(data.node, location, entityType, data.items);
                    }
                    lootData.remove(location);
                });
            }
        }
        for (Map.Entry entry : lootData.entrySet()) {
            gameplayConsumer.accept(((LootData)entry.getValue()).node, (class_2960)entry.getKey(), ((LootData)entry.getValue()).items());
        }
        lootData.clear();
        List<Map.Entry> entries = class_7923.field_41195.method_29722().stream().sorted(Comparator.comparing(a -> ((class_5321)a.getKey()).method_29177().method_12832())).toList();
        for (Map.Entry entry : entries) {
            location = ((class_5321)entry.getKey()).method_29177();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(class_1792::method_7854).toList();
            outputs = tradeEntry.outputs.stream().map(class_1792::method_7854).toList();
            traderConsumer.accept(tradeEntry.node, location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (class_2960)entry.getKey();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(class_1792::method_7854).toList();
            outputs = tradeEntry.outputs.stream().map(class_1792::method_7854).toList();
            wanderingTraderConsumer.accept(tradeEntry.node, location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }

    public record TradeData(IDataNode node, List<class_1792> inputs, List<class_1792> outputs) {
    }

    public record LootData(IDataNode node, List<class_1799> items) {
    }
}

