/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs;

import com.almostreliable.lootjs.core.LootType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static <T> List<T> getCapturedInstances(Predicate<?> predicate, Class<T> requiredType) {
        ArrayList<T> instances = new ArrayList<T>();
        try {
            Field[] fields;
            for (Field field : fields = predicate.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object entry = field.get(predicate);
                if (!requiredType.isInstance(entry)) continue;
                instances.add(requiredType.cast(entry));
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Error while accessing field: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Security error while accessing field: " + e.getMessage());
        }
        return instances;
    }

    @NotNull
    public static Predicate<ResourceLocation> typePredicate(LootType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case LootType.UNKNOWN, LootType.VAULT, LootType.ADVANCEMENT_REWARD, LootType.ADVANCEMENT_ENTITY, LootType.ADVANCEMENT_LOCATION, LootType.COMMAND, LootType.SELECTOR -> r -> false;
            case LootType.BLOCK, LootType.BLOCK_USE -> r -> r.getPath().startsWith("blocks/");
            case LootType.CHEST -> r -> r.getPath().startsWith("chests/");
            case LootType.FISHING -> r -> r.getPath().startsWith("gameplay/fishing");
            case LootType.ENTITY -> r -> r.getPath().startsWith("entities/");
            case LootType.EQUIPMENT -> r -> r.getPath().startsWith("equipment/");
            case LootType.ARCHAEOLOGY -> r -> r.getPath().startsWith("archaeology/");
            case LootType.GIFT -> r -> r.getPath().endsWith("_gift");
            case LootType.PIGLIN_BARTER -> r -> r.getPath().endsWith("_bartering");
            case LootType.SHEARING -> r -> r.getPath().startsWith("shearing/");
            case LootType.GENERIC -> r -> true;
        };
    }
}

