/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs.node;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class ItemStackNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"lootjs", (String)"item_stack");
    private final List<ITooltipNode> tooltip;
    private final List<LootItemCondition> conditions;
    private final List<LootItemFunction> functions;
    private final ItemStack itemStack;
    private final RangeValue count;
    private final float chance;
    private final boolean modified;

    public ItemStackNode(IServerUtils utils, ItemStack itemStack, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions, boolean preserveCount) {
        this(utils, itemStack, chance, false, functions, conditions, preserveCount);
    }

    public ItemStackNode(IServerUtils utils, ItemStack itemStack, float chance, boolean modified, List<LootItemFunction> functions, List<LootItemCondition> conditions, boolean preserveCount) {
        this.conditions = conditions;
        this.functions = functions;
        this.itemStack = TooltipUtils.getItemStack(utils, itemStack.copyWithCount(1), this.functions);
        this.chance = chance;
        this.modified = modified;
        if (preserveCount) {
            this.tooltip = ItemStackNode.getItemTooltip(utils, 1, chance, functions, conditions);
            this.count = ItemStackNode.getCount(utils, 1, functions).get(null).get(0);
        } else {
            this.tooltip = ItemStackNode.getItemTooltip(utils, itemStack.getCount(), chance, Collections.emptyList(), Collections.emptyList());
            this.count = ItemStackNode.getCount(utils, itemStack.getCount(), Collections.emptyList()).get(null).get(0);
        }
    }

    public ItemStackNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        this.itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
        this.count = new RangeValue((FriendlyByteBuf)buf);
        this.modified = buf.readBoolean();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
        this.chance = 1.0f;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return Either.left((Object)this.itemStack);
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.itemStack);
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
        this.count.encode((FriendlyByteBuf)buf);
        buf.writeBoolean(this.modified);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    private static List<ITooltipNode> getItemTooltip(IServerUtils utils, int baseCount, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, conditions, chance);
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> countMap = ItemStackNode.getCount(utils, baseCount, functions);
        return EntryTooltipUtils.getTooltip(utils, 0, chanceMap, countMap, functions, conditions);
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getCount(IServerUtils utils, int baseCount, List<LootItemFunction> functions) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> count = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue(baseCount)));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }
}

