/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs.server;

import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.MatchAnyInventorySlot;
import com.almostreliable.lootjs.loot.condition.MatchBiome;
import com.almostreliable.lootjs.loot.condition.MatchDimension;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.MatchStructure;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.mixin.MixinCustomParamPredicate;
import com.yanny.ali.plugin.lootjs.server.LootJsGenericTooltipUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.Arrays;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class LootJsConditionTooltipUtils {
    @NotNull
    public static ITooltipNode matchBiomeTooltip(IServerUtils utils, MatchBiome condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_biome", new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderSetTooltip(utils, "ali.property.branch.biomes", "ali.property.value.null", condition.biomes(), RegistriesTooltipUtils::getBiomeTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode matchDimensionTooltip(IServerUtils utils, MatchDimension condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_dimension", new Object[0]));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.dimensions", "ali.property.value.null", Arrays.asList(condition.dimensions()), GenericTooltipUtils::getResourceLocationTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode matchStructureTooltip(IServerUtils utils, MatchStructure condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_structure", new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderSetTooltip(utils, "ali.property.branch.structures", "ali.property.value.null", condition.structures(), RegistriesTooltipUtils::getStructureTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.exact", condition.exact()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode customParamPredicateTooltip(IServerUtils ignoredUtils, CustomParamPredicate<?> condition) {
        MixinCustomParamPredicate cond = (MixinCustomParamPredicate)condition;
        if (cond.getParam() == LootContextParams.THIS_ENTITY) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_entity_custom", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        if (cond.getParam() == LootContextParams.ATTACKING_ENTITY) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_attacker_custom", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        if (cond.getParam() == LootContextParams.DIRECT_ATTACKING_ENTITY) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_direct_attacker_custom", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        if (cond.getParam() == LootContextParams.BLOCK_ENTITY) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.block_entity", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode isLightLevelTooltip(IServerUtils utils, IsLightLevel condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.is_light_level", new Object[0]));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.value", IntRange.range((int)condition.min(), (int)condition.max())));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMatchEquipmentSlotTooltip(IServerUtils utils, MatchEquipmentSlot condition) {
        switch (condition.slot()) {
            case MAINHAND: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_mainhand", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", condition.itemFilter()));
                return tooltip;
            }
            case OFFHAND: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_offhand", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", condition.itemFilter()));
                return tooltip;
            }
            case FEET: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_feet", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", condition.itemFilter()));
                return tooltip;
            }
            case LEGS: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_legs", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", condition.itemFilter()));
                return tooltip;
            }
            case CHEST: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_chest", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", condition.itemFilter()));
                return tooltip;
            }
            case HEAD: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_head", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", condition.itemFilter()));
                return tooltip;
            }
        }
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_equipment_slot", new Object[0]));
        tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", condition.itemFilter()));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.slot", condition.slot()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode matchKillerDistanceTooltip(IServerUtils utils, MatchKillerDistance condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_distance", new Object[0]));
        tooltip.add(GenericTooltipUtils.getDistancePredicateTooltip(utils, "ali.property.value.predicate", condition.predicate()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode matchPlayerTooltip(IServerUtils utils, MatchPlayer condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_player", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.value.predicate", condition.predicate()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode playerParamPredicateTooltip(IServerUtils ignoredUtils, PlayerParamPredicate ignoredCondition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_player_custom", new Object[0]));
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode matchAnyInventorySlot(IServerUtils utils, MatchAnyInventorySlot condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_any_inventory_slot", new Object[0]));
        tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.branch.predicate", condition.filter()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.hotbar", condition.hotbar()));
        return tooltip;
    }
}

