/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.yanny.ali.api.ITooltipNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import org.jetbrains.annotations.Nullable;

public final class TooltipNode
implements ITooltipNode {
    private final Component component;
    private final boolean advancedTooltip;
    @Nullable
    private List<ITooltipNode> children = null;

    public TooltipNode() {
        this((Component)Component.empty(), false);
    }

    public TooltipNode(Component component) {
        this(component, false);
    }

    public TooltipNode(Component component, boolean advancedTooltip) {
        this.component = component;
        this.advancedTooltip = advancedTooltip;
    }

    public TooltipNode(RegistryFriendlyByteBuf buf) {
        int count = buf.readInt();
        this.advancedTooltip = buf.readBoolean();
        this.component = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        if (count == 0) {
            this.children = Collections.emptyList();
        } else if (count == 1) {
            this.children = Collections.singletonList(new TooltipNode(buf));
        } else {
            this.children = new ArrayList<ITooltipNode>(count);
            for (int i = 0; i < count; ++i) {
                this.children.add(new TooltipNode(buf));
            }
        }
    }

    @Override
    public void add(ITooltipNode node) {
        if (this.children == null) {
            this.children = new ArrayList<ITooltipNode>();
        }
        this.children.add(node);
    }

    @Override
    public List<ITooltipNode> getChildren() {
        return Objects.requireNonNullElse(this.children, Collections.emptyList());
    }

    @Override
    public Component getContent() {
        return this.component;
    }

    @Override
    public boolean isAdvancedTooltip() {
        return this.advancedTooltip;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        List<ITooltipNode> children = this.getChildren();
        buf.writeInt(children.size());
        buf.writeBoolean(this.advancedTooltip);
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.component);
        for (ITooltipNode child : children) {
            child.encode(buf);
        }
    }
}

